/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.codegen.RenameTests;

import java.util.Iterator;
import java.util.List;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.Assignment;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.ExpressionStatement;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.ForStatement;
import org.netbeans.jmi.javamodel.InfixExpression;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Literal;
import org.netbeans.jmi.javamodel.LocalVarDeclaration;
import org.netbeans.jmi.javamodel.LocalVariable;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MethodInvocation;
import org.netbeans.jmi.javamodel.NewClassExpression;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.jmi.javamodel.VariableAccess;
import org.netbeans.jmi.javamodel.codegen.CodegenTestCase;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.junit.NbTestSuite;

/**
 * Tests re-generating of names in different elements.
 *
 * @author  Pavel Flaska
 */
public class RenameTestField extends CodegenTestCase {
    
    /** Need to be defined because of JUnit */
    public RenameTestField(String name) {
        super(name, "RenameTestField");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new RenameTestField("testRename"));
        return suite;
    }
    
    JavaClass clazz;
    JavaModelPackage pkg;
    Feature[] feature = new Feature[4];

    private static final String newName = "renamedStr";
    
    protected void setUp() {
        clazz = Utility.findClass("org.netbeans.test.codegen.RenameTestField");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
        // initialize methods
        int i = 0;
        for (Iterator fIt = clazz.getFeatures().iterator(); fIt.hasNext(); i++) {
            feature[i] = (Feature) fIt.next();
        }
    }
    
    public void testRename() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Constructor constructor = (Constructor) feature[1];
            StatementBlock body = constructor.getBody();
            List st = body.getStatements();
            Assignment ass = (Assignment) ((ExpressionStatement) st.get(0)).getExpression();
            VariableAccess va = (VariableAccess) ass.getLeftSide();
            va.setName(newName);
            
            Method method = (Method) feature[2];
            body = method.getBody();
            st = body.getStatements();
            
            // for...
            ForStatement fs = (ForStatement) st.get(0);
            InfixExpression ie = (InfixExpression) fs.getExpression();
            MethodInvocation mi = (MethodInvocation) ie.getRightSide();
            va = (VariableAccess) mi.getParentClass();
            va.setName(newName);
            
            // strToBeRenamed += " is not a trademark.";
            ass = (Assignment) ((ExpressionStatement) st.get(1)).getExpression();
            va = (VariableAccess) ass.getLeftSide();
            va.setName(newName);
            
            // String nuovo = strToBeRenamed;
            LocalVarDeclaration lvd = (LocalVarDeclaration) st.get(2);
            LocalVariable lv = (LocalVariable) lvd.getVariables().get(0);
            lv.setInitialValueText(newName);
            
            // StringBuffer buf = new StringBuffer(strToBeRenamed);
            lvd = (LocalVarDeclaration) st.get(3);
            lv = (LocalVariable) lvd.getVariables().get(0);
            NewClassExpression nce = (NewClassExpression) lv.getInitialValue();
            va = (VariableAccess) nce.getParameters().get(0);
            va.setName(newName);
            
            // strToBeRenamed = "Do not change!";
            ass = (Assignment) ((ExpressionStatement) st.get(4)).getExpression();
            va = (VariableAccess) ass.getLeftSide();
            va.setName(newName);
            
            // getLength(strToBeRenamed);
            mi = (MethodInvocation) ((ExpressionStatement) st.get(5)).getExpression();
            va = (VariableAccess) mi.getParameters().get(0);
            va.setName(newName);
            
            feature[0].setName(newName);

            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }
        makeDiff("testRename");
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
    
}
