/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.jmi.javamodel.codegen;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Collections;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.junit.*;
import org.openide.filesystems.FileStateInvalidException;

/**
 *
 * @author  Pavel Flaska
 */
public class SuperClassTest extends NbTestCase {
    
    JavaClass clazz;
    String cbn;
    JavaModelPackage pkg;
    
    /** Creates a new instance of SuperClassTest */
    public SuperClassTest() {
        super("SuperClassTest");
    }
    
    protected void setUp() {
        clazz = Utility.findClass("org.netbeans.test.codegen.SuperClassTest");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(SuperClassTest.class);
        return suite;
    }

    public void testAddClass() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            MultipartId multi = pkg.getMultipartId().createMultipartId("SecondInnerClass", null, null);
            JavaClass innerClass = pkg.getJavaClass().createJavaClass(
                "ThirdInnerClass",     // name
                null,                  // annnotations
                Modifier.STATIC,       // modifiers
                null,                  // javadoc
                null,                  // javaDoc text
                Collections.EMPTY_LIST, // empty features
                multi,                 // superclass
                null,                  // interfaces
                null
                );
            clazz.getContents().add(innerClass);
            fail = false;
        } finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/SuperClassTest.java"),
            getGoldenFile("testAddClass_SuperClassTest.pass"),
            getWorkDir()
        );
    }

    public void testChange() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            JavaClass inner = (JavaClass) clazz.getContents().get(2);
            MultipartId id = pkg.getMultipartId().createMultipartId("SuperClassTest", null, null);
            inner.setSuperClass((JavaClass) clazz.getContents().get(1));
            inner.setSuperClassName(id);
            fail = false;
        } finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/SuperClassTest.java"),
            getGoldenFile("testChange_SuperClassTest.pass"),
            getWorkDir()
        );
    }

    public void testAddSuper() throws FileStateInvalidException, IOException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            JavaClass inner = (JavaClass) clazz.getContents().get(1);
            MultipartId id = pkg.getMultipartId().createMultipartId("NoExt", null, null);
            inner.setSuperClassName(id);
            inner.setSuperClass(clazz);
            fail = false;
        } finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/SuperClassTest.java"),
            getGoldenFile("testAddSuper_SuperClassTest.pass"),
            getWorkDir()
        );
    }
        
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        // TODO code application logic here
    }
    
}
