/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.jmi.javamodel.codegen;

import java.util.List;
import java.io.IOException;
import org.openide.filesystems.FileStateInvalidException;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;

/**
 *
 * @author  Pavel Flaska
 */
public class VariableAccessTypeTest extends NbTestCase {
    
    /** Creates a new instance of VariableAccessTypeTest */
    public VariableAccessTypeTest() {
        super("VariableAccessTypeTest");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(VariableAccessTypeTest.class);
        return suite;
    }
    
    private JavaModelPackage pkg;
    private JavaClass clazz;
    
    protected void setUp() {
        clazz = Utility.findClass("org.netbeans.test.codegen.VariableAccessTypeClass");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
    }
    
    public void testFieldAccess() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Constructor constr = (Constructor) clazz.getContents().get(1);
            ExpressionStatement stat = (ExpressionStatement) constr.getBody().getStatements().get(0);
            Assignment assign = (Assignment) stat.getExpression();
            VariableAccess varAcc = (VariableAccess) assign.getLeftSide();
            if ("int".equals(varAcc.getType().getName()) == false) {
                fail("Expected return type VariableAccessTypeClass not found. (Found " + varAcc.getType().getName() + ").");
            }
            fail = false;
        } finally {
            Utility.endTrans(fail);
        }
    }

    public void testLocVarAccess() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Method method = (Method) clazz.getContents().get(2);
            LocalVarDeclaration stat = (LocalVarDeclaration) method.getBody().getStatements().get(0);
            LocalVariable lvar = (LocalVariable) stat.getVariables().get(0);
            VariableAccess init = (VariableAccess) lvar.getInitialValue();
            Type type = init.getType();
            if ("org.netbeans.test.codegen.VariableAccessTypeClass".equals(type.getName()) == false) {
                fail("Expected return type VariableAccessTypeClass not found. (Found " + type.getName() + ").");
            }
            fail = false;
        } finally {
            Utility.endTrans(fail);
        }
    }

    public void testGetRetTypeVarAccess() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Method method = (Method) clazz.getContents().get(2);
            ReturnStatement stat = (ReturnStatement) method.getBody().getStatements().get(1);
            VariableAccess varAcc = (VariableAccess) stat.getExpression();
            if ("org.netbeans.test.codegen.VariableAccessTypeClass".equals(varAcc.getType().getName()) == false) {
                fail("Expected return type VariableAccessTypeClass not found. (Found " + varAcc.getType().getName() + ").");
            }
            fail = false;
        } finally {
            Utility.endTrans(fail);
        }
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
}
