/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.codegen.indent;

import org.netbeans.jmi.javamodel.Assignment;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.InitialValue;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.LocalVarDeclaration;
import org.netbeans.jmi.javamodel.LocalVariable;
import org.netbeans.jmi.javamodel.OperatorEnum;
import org.netbeans.jmi.javamodel.TryStatement;
import org.netbeans.jmi.javamodel.VariableAccess;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.openide.filesystems.FileStateInvalidException;

/**
 *
 * @author Pavel Flaska
 */
public class BlenderTest extends NbTestCase {
    
    JavaClass clazz;
    JavaModelPackage pkg;
    
    /** Creates a new instance of BlenderTest */
    public BlenderTest() {
        super("BlenderTest");
    }
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(BlenderTest.class);
        return suite;
    }
    
    protected void setUp() {
        clazz = (JavaClass) Utility.findClass("org.netbeans.test.codegen.indent.Blender");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
    }

    public void testMixStatements() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Constructor constructor = (Constructor) clazz.getContents().get(0);
            TryStatement tryStmt = (TryStatement) constructor.getBody().getStatements().get(1);
            LocalVarDeclaration lvd = (LocalVarDeclaration) tryStmt.getBody().getStatements().remove(0);
            LocalVariable lv = (LocalVariable) lvd.getVariables().get(0);
            InitialValue iv = lv.getInitialValue();
            lv.setInitialValue(null);
            VariableAccess va = (VariableAccess) pkg.getVariableAccess().createVariableAccess(lv.getName(), null, false);
            Assignment a = pkg.getAssignment().createAssignment(va, OperatorEnum.ASSIGN, (Expression) iv);
            constructor.getBody().getStatements().add(1, lvd);
            tryStmt.getBody().getStatements().add(0, pkg.getExpressionStatement().createExpressionStatement(a));
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/indent/Blender.java"),
            getGoldenFile("testMixStatements_BlenderTest.pass"),
            getWorkDir()
        );
    }
}
