/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.codegen.indent;

import java.io.IOException;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MethodImpl;
import org.openide.filesystems.FileStateInvalidException;

/**
 *
 * @author Pavel Flaska
 */
public class MoveElementsTest extends NbTestCase {
    
    JavaClass sourceClass, destClass;
    JavaModelPackage pkg;
    
    /** Creates a new instance of MoveElementsTest */
    public MoveElementsTest(String s) {
        super(s);
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new MoveElementsTest("testMoveAlois"));
        suite.addTest(new MoveElementsTest("testMoveLojza"));
        suite.addTest(new MoveElementsTest("testMoveGianluigi"));
        suite.addTest(new MoveElementsTest("testMoveCall"));
        return suite;
    }
    
    protected void setUp() {
        sourceClass = (JavaClass) Utility.findClass("org.netbeans.test.codegen.indent.GarbageClass");
        destClass = (JavaClass) Utility.findClass("org.netbeans.test.codegen.indent.TrashClass.FirstTrash");
        pkg = (JavaModelPackage) sourceClass.refImmediatePackage();
    }
    
    public void testMoveAlois() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            MethodImpl m = (MethodImpl) sourceClass.getContents().remove(0);
            destClass.getContents().add(m);
            m.fixImports(destClass, m);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/indent/TrashClass.java"),
                getGoldenFile("testMoveAlois_MoveElementsTest.pass"),
            getWorkDir()
        );
    }
    
    public void testMoveLojza() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            MethodImpl m = (MethodImpl) sourceClass.getContents().remove(0);
            destClass.getContents().add(m);
            m.fixImports(destClass, m);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/indent/TrashClass.java"),
                getGoldenFile("testMoveLojza_MoveElementsTest.pass"),
            getWorkDir()
        );
    }
    
    public void testMoveGianluigi() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            MethodImpl m = (MethodImpl) sourceClass.getContents().remove(0);
            destClass.getContents().add(0, m);
            m.fixImports(destClass, m);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/indent/TrashClass.java"),
                getGoldenFile("testMoveGianluigi_MoveElementsTest.pass"),
            getWorkDir()
        );
    }
    
    public void testMoveCall() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            MethodImpl m = (MethodImpl) sourceClass.getContents().remove(0);
            destClass.getContents().add(m);
            m.fixImports(destClass, m);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/indent/TrashClass.java"),
                getGoldenFile("testMoveCall_MoveElementsTest.pass"),
            getWorkDir()
        );
    }
}
