/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.codegen.indent;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.jmi.javamodel.Catch;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.NewClassExpression;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.jmi.javamodel.StatementBlockClass;
import org.netbeans.jmi.javamodel.TryStatement;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.openide.filesystems.FileStateInvalidException;
import org.netbeans.jmi.javamodel.codegen.*;

/**
 *
 * @author Pavel Flaska
 */
public class SurroundExistingBodyTest extends NbTestCase {
    
    JavaClass clazz;
    JavaModelPackage pkg;
    
    /**
     * Creates a new instance of SurroundExistingBodyTest 
     */
    public SurroundExistingBodyTest() {
        super("SurroundExistingBodyTest");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(SurroundExistingBodyTest.class);
        return suite;
    }
    
    protected void setUp() {
        clazz = (JavaClass) Utility.findClass("org.netbeans.test.codegen.indent.SurroundExistingBody");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
    }

    public void testSurroundBlockWithTry() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true; 
        Utility.beginTrans(true);
        try {
            Constructor constructor = (Constructor) clazz.getContents().get(0);
            
            List statements = constructor.getBody().getStatements();
            StatementBlockClass sbc = pkg.getStatementBlock();
            // catch (Exception e) -- parameter
            Parameter p = pkg.getParameter().createParameter("e", null, false, pkg.getMultipartId().createMultipartId("java.lang.Exception", null, null), 0, false);
            // try body
            StatementBlock bodyBody = sbc.createStatementBlock(); 
            // adding statements to try body
            Object[] arr = statements.toArray();
            for (int i = 1; i < arr.length; i++) {
                statements.remove(arr[i]);
                bodyBody.getStatements().add(arr[i]);
            }
            // finally body
            StatementBlock finallyBody = sbc.createStatementBlock();
            finallyBody.getStatements().add(pkg.getEmptyStatement().createEmptyStatement());
            // catch body
            StatementBlock catchBody = sbc.createStatementBlock();
            NewClassExpression e = pkg.getNewClassExpression().createNewClassExpression(
                    "Throwable", 
                    Collections.singletonList(pkg.getStringLiteral().createStringLiteral("Bad day!")),
                    null,
                    null,
                    null
                    );
            catchBody.getStatements().add(pkg.getThrowStatement().createThrowStatement(e));
            statements.add(pkg.getTryStatement().createTryStatement(bodyBody, Collections.singletonList(pkg.getCatch().createCatch(p, catchBody)), finallyBody));
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/indent/SurroundExistingBody.java"),
            getGoldenFile("SurroundExistingBody_SurroundExistingBodyTest.pass"),
            getWorkDir()
        );
    }
    
}
