/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.codegen.trywrapper;

import java.util.Collections;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.javacore.TryWrapper;
import org.openide.filesystems.FileStateInvalidException;

/**
 *
 * @author Pavel Flaska
 */
public class TryWrapper1Test extends NbTestCase {
    
    JavaClass[] clazz = new JavaClass[2];
    JavaModelPackage pkg;
    
    /** Creates a new instance of TryWrapper1Test */
    public TryWrapper1Test() {
        super("TryWrapper1Test");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(TryWrapper1Test.class);
        return suite;
    }
    
    protected void setUp() {
        clazz[0] = (JavaClass) Utility.findClass("org.netbeans.test.codegen.trywrapper.TryWrapper1Class");
        clazz[1] = (JavaClass) Utility.findClass("org.netbeans.test.codegen.trywrapper.TryWrapper2Class");
        pkg = (JavaModelPackage) clazz[0].refImmediatePackage();
    }
    
    public void testWrapSingle1() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Object o = ((Constructor) clazz[0].getContents().get(0)).getBody().getStatements().get(0);
            TryWrapper tewecko = new TryWrapper(Collections.singletonList(o));
            tewecko.wrap();
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/trywrapper/TryWrapper1Class.java"),
            getGoldenFile("testWrapSingle1.pass"),
            getWorkDir()
        );
    }
    
    public void testWrapMoreVars() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Object o = ((Constructor) clazz[1].getContents().get(0)).getBody().getStatements().get(0);
            TryWrapper tewecko = new TryWrapper(Collections.singletonList(o));
            tewecko.wrap();
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/trywrapper/TryWrapper2Class.java"),
            getGoldenFile("testWrapMoreVars.pass"),
            getWorkDir()
        );
    }
   
}
