/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.getters;

import java.util.Iterator;
import java.util.List;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.LocalVarDeclaration;
import org.netbeans.jmi.javamodel.LocalVariable;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;

/**
 *
 * @author Pavel Flaska
 */
public class AnnLocalVarTest extends NbTestCase {
    
    JavaClass clazz;
    JavaModelPackage pkg;
    LocalVarDeclaration[] lvdecko = new LocalVarDeclaration[4];
    
    Annotation[] tmpAnnotation;
    boolean isFinal;
    
    /** Creates a new instance of AnnLocalVarTest */
    public AnnLocalVarTest() {
        super("AnnLocalVarTest");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(AnnLocalVarTest.class);
        return suite;
    }
    
    protected void setUp() {
        clazz = (JavaClass) Utility.findClass("org.netbeans.test.getters.AnnotationLocVar");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
        Constructor c = (Constructor) clazz.getContents().get(0);
        int i = 0;
        for (Iterator it = c.getBody().getStatements().iterator(); it.hasNext(); ) {
            //System.err.println(it.next());
            lvdecko[i++] = (LocalVarDeclaration) it.next();
        }
    }
    
    public void testStatement1() {
        // final @AnnotationType(id=1, synopsis="Papaya", engineer="Snoopy", date="2004") java.util.List l;
        logData(0);
        assertEquals(true, isFinal);
        assertEquals(1, tmpAnnotation.length);
        assertEquals("AnnotationType", tmpAnnotation[0].getTypeName().getName());
    }
    
    public void testStatement2() {
        // @SuppressWarnings(value={"a", "b"}) @AnnotationType(id=2, synopsis="Flower", engineer="Duke", date="2001") int a;
        logData(1);
        assertEquals(false, isFinal);
        assertEquals(2, tmpAnnotation.length);
        assertEquals("SuppressWarnings", tmpAnnotation[0].getTypeName().getName());
        assertEquals("AnnotationType", tmpAnnotation[1].getTypeName().getName());
    }
    
    public void testStatement3() {
        // final long c = 10;
        logData(2);
        assertEquals(true, isFinal);
        assertEquals(0, tmpAnnotation.length);
    }
    
    public void testStatement4() {
        // @AnnotationType(id=3, synopsis="Aquila", engineer="Krystof", date="1851") final @SuppressWarnings(value={"c", "d"}) String d;
        logData(3);
        assertEquals(true, isFinal);
        assertEquals(2, tmpAnnotation.length);
        assertEquals("AnnotationType", tmpAnnotation[0].getTypeName().getName());
        assertEquals("SuppressWarnings", tmpAnnotation[1].getTypeName().getName());
    }
    
    private void logData(int statementIndex) {
        Utility.beginTrans(false);
        try {
            LocalVarDeclaration l = lvdecko[statementIndex];
            isFinal = l.isFinal();
            getLog().println("Final? " + isFinal);
            List/*<Annotation>*/ anns = ((LocalVariable) l.getVariables().get(0)).getAnnotations();
            tmpAnnotation = new Annotation[anns.size()];
            int i = 0;
            for (Iterator it = anns.iterator(); it.hasNext(); ) {
                Annotation ann = (Annotation) it.next();
                tmpAnnotation[i++] = ann;
                getLog().println("Ann: " + ann.getTypeName().getName());
            }
        }
        finally {
            Utility.endTrans();
        }
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
    
}
