/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.getters;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.jmi.javamodel.*;

/**
 * Test getAnnotation() on elements.
 *
 * @author  Pavel Flaska
 */
public class GetAnnotationTests extends NbTestCase {
    
    JavaClass clazz;
    JavaModelPackage pkg;
    
    /** Creates a new instance of GetAnnotationTests */
    public GetAnnotationTests() {
        super("GetAnnotationTests");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(GetAnnotationTests.class);
        return suite;
    }
    
    protected void setUp() {
        clazz = (JavaClass) Utility.findClass("org.netbeans.test.getters.AnnotationEverywhere");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
    }
    
    private String[] attrsNames = {
        "id",
        "synopsis",
        "engineer",
        "date"
    };
    
    public void testFieldAnnotation() {
        PrintStream log = getLog();
        Field f = clazz.getField("a", false);
        for (Iterator it0 = f.getAnnotations().iterator(); it0.hasNext(); ) {
            Annotation ann = (Annotation) it0.next();
            log.println("Annotation: '" + ann.getTypeName().getName() + "'");
            int i = 0;
            for (Iterator it1 = ann.getAttributeValues().iterator(); it1.hasNext(); i++) {
                AttributeValue attr = (AttributeValue) it1.next();
                log.println("\tname = '" + attr.getName() + "', value = '" + attr.getValue());
                assertEquals(attrsNames[i], attr.getName());
            }
        }
    }
    
    public void testConstructorAnnotation() {
        PrintStream log = getLog();
        Constructor c = (Constructor) clazz.getContents().get(1);
        log.println("Constructor: '" + c.getDeclaringClass().getName() + "':");
        int i = 0;
        for (Iterator it0 = c.getAnnotations().iterator(); it0.hasNext(); i++) {
            String name = ((Annotation) it0.next()).getTypeName().getName();
            log.println("\t" + name + ".");
            assertEquals(parAnnNames[i], name);
        }
    }
    
    private String[] parAnnNames = {
        "Deprecated",
        "AnnotationType"
    };
    
    public void testParameterAnnotation() {
        PrintStream log = getLog();
        Method m = (Method) clazz.getContents().get(2);
        List/*<Parameter>*/ l = m.getParameters();
        for (Iterator it0 = l.iterator(); it0.hasNext(); ) {
            Parameter p = (Parameter) it0.next();
            log.println("Parameter: '" + p.getName() + "':");
            int i = 0;
            for (Iterator it1 = p.getAnnotations().iterator(); it1.hasNext(); i++) {
                String name = ((Annotation) it1.next()).getTypeName().getName();
                log.println("\tannotation: '" + name + "'");
                assertEquals(parAnnNames[i], name);
            }
        }
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
    
}
