/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.getters;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.classfile.ClassFile;

/**
 * Checks the correctness of parameter's name
 *
 * @author Pavel Flaska
 */
public class ParamNameTest extends NbTestCase {
    
    JavaClass clazz;
    JavaModelPackage pkg;
    
    String[] result = {
	"void assertTrue(java.lang.String message, boolean condition)",
	"void assertTrue(boolean condition)",
	"void assertFalse(java.lang.String message, boolean condition)",
	"void assertFalse(boolean condition)",
	"void fail(java.lang.String message)",
	"void fail()",
	"void assertEquals(java.lang.String message, java.lang.Object expected, java.lang.Object actual)",
	"void assertEquals(java.lang.Object expected, java.lang.Object actual)",
	"void assertEquals(java.lang.String message, java.lang.String expected, java.lang.String actual)",
	"void assertEquals(java.lang.String expected, java.lang.String actual)",
	"void assertEquals(java.lang.String message, double expected, double actual, double delta)",
	"void assertEquals(double expected, double actual, double delta)",
	"void assertEquals(java.lang.String message, float expected, float actual, float delta)",
	"void assertEquals(float expected, float actual, float delta)",
	"void assertEquals(java.lang.String message, long expected, long actual)",
	"void assertEquals(long expected, long actual)",
	"void assertEquals(java.lang.String message, boolean expected, boolean actual)",
	"void assertEquals(boolean expected, boolean actual)",
	"void assertEquals(java.lang.String message, byte expected, byte actual)",
	"void assertEquals(byte expected, byte actual)",
	"void assertEquals(java.lang.String message, char expected, char actual)",
	"void assertEquals(char expected, char actual)",
	"void assertEquals(java.lang.String message, short expected, short actual)",
	"void assertEquals(short expected, short actual)",
	"void assertEquals(java.lang.String message, int expected, int actual)",
	"void assertEquals(int expected, int actual)",
	"void assertNotNull(java.lang.Object object)",
	"void assertNotNull(java.lang.String message, java.lang.Object object)",
	"void assertNull(java.lang.Object object)",
	"void assertNull(java.lang.String message, java.lang.Object object)",
	"void assertSame(java.lang.String message, java.lang.Object expected, java.lang.Object actual)",
	"void assertSame(java.lang.Object expected, java.lang.Object actual)",
	"void assertNotSame(java.lang.String message, java.lang.Object expected, java.lang.Object actual)",
	"void assertNotSame(java.lang.Object expected, java.lang.Object actual)",
	"void failSame(java.lang.String message)",
	"void failNotSame(java.lang.String message, java.lang.Object expected, java.lang.Object actual)",
	"void failNotEquals(java.lang.String message, java.lang.Object expected, java.lang.Object actual)",
	"java.lang.String format(java.lang.String message, java.lang.Object expected, java.lang.Object actual)"
    };

    /** Creates a new instance of ParamNameTest */
    public ParamNameTest() {
        super("ParamNameTest");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(ParamNameTest.class);
        return suite;
    }
    
    protected void setUp() {
        clazz = (JavaClass) Utility.findClass("junit.framework.Assert");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
    }

    public void test() {
        if (clazz instanceof JavaClass) {
            getLog().println(clazz.getName() + " contains methods:");
            int counter = 0;
            for (Iterator/*Feature*/ it = clazz.getFeatures().iterator(); it.hasNext(); ) {
                Feature f = (Feature) it.next();
                if (f instanceof Method) {
                    Method m = (Method) f;
                    String s = m.getType().getName() + ' ' + m.getName() + '(';
                    for (Iterator itPar = m.getParameters().iterator(); itPar.hasNext(); ) {
                        Parameter p = (Parameter) itPar.next();
                        s += p.getType().getName() + ' ' + p.getName();
                        if (itPar.hasNext()) {
                            s += ", ";
                        } else {
                            break;
                        }
                    }
                    s += ')';
                    getLog().println("\t" + s);
                    assertEquals(result[counter], s);
                    counter++;
                }
            }
        } else {
            getLog().println("Cannot resolve class!");
        }
    }
    
    private void temporary() {
        try {
            ClassFile f = new ClassFile("/tmp/junit/framework/Assert.class", true);
            Collection/*Method*/ c = f.getMethods();
            for (Iterator mIt = c.iterator(); mIt.hasNext(); ) {
                org.netbeans.modules.classfile.Method m = (org.netbeans.modules.classfile.Method) mIt.next();
                getLog().print(m.getName() + "(");
                List/*Parameter*/ pars = m.getParameters();
                for (Iterator pIt = pars.iterator(); pIt.hasNext(); ) {
                    org.netbeans.modules.classfile.Parameter p = (org.netbeans.modules.classfile.Parameter) pIt.next();
                    getLog().print(p.getDescriptor() + " " + p.getName());
                    if (pIt.hasNext()) {
                        getLog().print(", ");
                    }
                }
                getLog().println(")");
            }
        } catch (Exception e) {
            assertFalse(false);
        }
    }
    
}
