/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.getters;

import java.util.LinkedList;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.junit.NbTestCase;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;


/**
 * @author Pavel Flaska
 */
public class SuperClassTest extends NbTestCase {
    
    JavaClass clazz;
    JavaModelPackage pkg;
    JavaMetamodel model;
   
    public SuperClassTest() {
        super("SuperClassTest");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(SuperClassTest.class);
        return suite;
    }
    
    protected void setUp() {
        clazz = (JavaClass) Utility.findClass("org.netbeans.test.getters.SecondClass");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
        model = JavaMetamodel.getManager();
    }
    
    public void test() {
        boolean fail = true;
        Utility.beginTrans(false);
        try {
            assertEquals("org.netbeans.test.getters.FirstClass", clazz.getSuperClass().getName());
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        TestRunner.run(suite());
    }
}
