/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * Regenerator.java
 *
 * Created on 04 December 2003, 16:40
 */

package org.netbeans.jmi.javamodel.regenerator;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import junit.framework.AssertionFailedError;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.junit.diff.Diff;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

/**
 *
 * @author  Jan Becicka
 */
public class Regenerator {
    
    /**
     * Holds value of property sourceFileSystem.
     */
    private FileSystem sourceFileSystem;
    
    /**
     * Holds value of property targetFileSystem.
     */
    private FileSystem targetFileSystem;
    
    private Cloner cloner;
    
    /** Creates a new instance of Regenerator */
    public Regenerator() {
    }
    
    /**
     * Getter for property sourceFileSystem.
     * @return Value of property sourceFileSystem.
     */
    public FileSystem getSourceFileSystem() {
        return this.sourceFileSystem;
    }
    
    /**
     * Setter for property sourceFileSystem.
     * @param sourceFileSystem New value of property sourceFileSystem.
     */
    public void setSourceFileSystem(FileSystem sourceFileSystem) {
        this.sourceFileSystem = sourceFileSystem;
    }
    
    /**
     * Getter for property targetFileSystem.
     * @return Value of property targetFileSystem.
     */
    public FileSystem getTargetFileSystem() {
        return this.targetFileSystem;
    }
    
    /**
     * Setter for property targetFileSystem.
     * @param targetFileSystem New value of property targetFileSystem.
     */
    public void setTargetFileSystem(FileSystem targetFileSystem) {
        this.targetFileSystem = targetFileSystem;
        cloner = new Cloner(targetFileSystem);
    }
    
    public void regenerate(String resourceName) {
        regenerate(JavaMetamodel.getManager().getResource(sourceFileSystem.getRoot(), resourceName));
    }
    
    public void regenerate(Resource resource) {
        Resource result;
        Utility.beginTrans(true);
        try {
            result = cloner.duplicate(resource);
        } finally {
            Utility.endTrans(false);
        }
        Diff diff = new LexDiff();
        File sourceFile = FileUtil.toFile(JavaMetamodel.getManager().getFileObject(resource));
        File targetFile = FileUtil.toFile(JavaMetamodel.getManager().getFileObject(result));
        try {
            if ( diff.diff(sourceFile, targetFile, null)) {
                throw new AssertionFailedError("Test Failed !!! " + sourceFile.getName() + " differs from " + targetFile.getName());
            } else {
                System.out.println("Test Passed !!! " + sourceFile.getName());
            }
        } catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
    
    public void regenerateAll() {
        System.out.println("regenerate all");
        JavaModelPackage source = JavaMetamodel.getManager().resolveJavaExtent(sourceFileSystem.getRoot());
        for(Iterator it = source.getResource().refAllOfClass().iterator(); it.hasNext(); regenerate((Resource) it.next()));
    }
}
