/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.jmi.javamodel.usages;

import java.util.*;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.jmi.javamodel.MethodInvocation;
import org.netbeans.jmi.javamodel.VariableAccess;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;

/**
 * @author Daniel Prusa
 */
public class FindFeatureUsagesTest extends NbTestCase {
        
    /** Need to be defined because of JUnit */
    public FindFeatureUsagesTest(String name) {
        super(name);
        
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new FindFeatureUsagesTest("testColorPicker"));
        suite.addTest(new FindFeatureUsagesTest("testColorPreview"));
        suite.addTest(new FindFeatureUsagesTest("testTed"));
        return suite;
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        TestRunner.run(suite());
    }
    
    public void testColorPicker() {
        Map map = collectFeatures("examples.colorpicker.ColorPicker");
        // fields
        checkUsers(map, "blueSlider", 8);
        checkUsers(map, "colorPreview1", 7);
        checkUsers(map, "colorPreviewPanel", 7);
        checkUsers(map, "greenSlider", 8);
        checkUsers(map, "redSlider", 8);
        checkUsers(map, "sliderPanel", 7);
        // methods
        checkUsers(map, "blueSliderStateChanged", 1);
        checkUsers(map, "exitForm", 1);
        checkUsers(map, "greenSliderStateChanged", 1);
        checkUsers(map, "initComponents", 1);
        checkUsers(map, "main", 0);
        checkUsers(map, "redSliderStateChanged", 1);
    }

    public void testColorPreview() {
        Map map = collectFeatures("examples.colorpicker.ColorPreview");
        // fields
        checkUsers(map, "blue", 5);
        checkUsers(map, "green", 5);
        checkUsers(map, "propertyChangeSupport", 6);
        checkUsers(map, "red", 5);
        // methods
        checkUsers(map, "addPropertyChangeListener", 0);
        checkUsers(map, "getBlue", 0);
        checkUsers(map, "getGreen", 0);
        checkUsers(map, "getRed", 0);
        checkUsers(map, "removePropertyChangeListener", 0);
        checkUsers(map, "setBlue", 1);
        checkUsers(map, "setGreen", 1);
        checkUsers(map, "setRed", 1);
    }
    
    public void testTed() {
        Map map = collectFeatures("examples.texteditor.Ted");
        // fields
        checkUsers(map, "textBox", 8);
        checkUsers(map, "tedMenuBar", 7);
        checkUsers(map, "saveMenuItem", 8);
        checkUsers(map, "saveAsMenuItem", 7);
        checkUsers(map, "openMenuItem", 8);
        checkUsers(map, "jSeparator1", 2);
        checkUsers(map, "fileName", 7);
        // methods
        checkUsers(map, "doSave", 2);
        checkUsers(map, "doSaveAs", 2);
        checkUsers(map, "initComponents", 1);
        checkUsers(map, "openMenuItemActionPerformed", 1);
        checkUsers(map, "saveAsMenuItemActionPerformed", 1);
        checkUsers(map, "saveMenuItemActionPerformed", 1);
        checkUsers(map, "newMenuItemActionPerformed", 1);
        checkUsers(map, "exitMenuItemActionPerformed", 1);
        checkUsers(map, "findMenuItemActionPerformed", 1);
    }
    
    private Map collectFeatures (String className) {
        Utility.beginTrans(false);
        try {
            HashMap map = new HashMap();
            JavaClass jc = Utility.findClass(className);
            for (Iterator iter = jc.getFeatures().iterator(); iter.hasNext();) {
                Feature f = (Feature) iter.next();            
                String name;
                if ((f instanceof Field) || (f instanceof Method)) {
                    name = f.getName();
                } else if (f instanceof Constructor) {
                    name = "<init>";
                } else {
                    continue;
                }
                map.put(name, f);
            }
            return map;
        } finally {
            Utility.endTrans();
        }
    }
    
    private void checkUsers(Map map, String name, int expectedCount) {
        Utility.beginTrans(false);
        try {
            Feature feature = (Feature)map.get(name);
            assertNotNull(feature);
            Collection usages = feature.getReferences();

            if (expectedCount != usages.size()) {
                fail("feature: " + name + ", expected # of usages: " + expectedCount + ", usages found: " + usages.size());
            }

            Class usageClass = feature instanceof Field ? VariableAccess.class : MethodInvocation.class;

            for (Iterator iter = usages.iterator(); iter.hasNext();) {
                Object usage = iter.next();
                if (!usageClass.isAssignableFrom(usage.getClass())) {
                    fail("feature: " + name + ", expected an instance of " + usageClass.getName() +
                        ", found " + usage.getClass().getName());
                }
            }
        } finally {
            Utility.endTrans();
        }
    }
        
}
