/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.jmi.javamodel.usages;

import java.util.Collection;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;

/**
 * @author Jan Becicka (jbecicka@netbeans.org)
 */
public class FindPackageUsagesTest extends NbTestCase {
    
    public static final String[] USAGES_COLOR_PICKER = {
        "MultipartId",
        "MultipartId",
        "Resource",
        "Resource",
        "Resource"
    };
    
    public static final String[] USAGES_IMAGE_VIEWER = {
        "Resource",
        "Resource"
    };
        
    public static final String[] USAGES_TEXT_EDITOR = {
        "Resource",
        "Resource",
        "Resource"
    };
        
    public static final String[] USAGES_EXAMPLES = {
        "MultipartId",
        "MultipartId",
        "MultipartId",
        "MultipartId",
        "MultipartId",
        "MultipartId",
        "MultipartId",
        "MultipartId",
        "MultipartId",
        "MultipartId"
    };
    
    /** Need to be defined because of JUnit */
    public FindPackageUsagesTest(String name) {
        super(name);
        
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new FindPackageUsagesTest("testFindExamplesColorPicker"));
        suite.addTest(new FindPackageUsagesTest("testFindExamplesImageViewer"));
        suite.addTest(new FindPackageUsagesTest("testFindExamplesTextEditor"));
        suite.addTest(new FindPackageUsagesTest("testFindExamples"));
        return suite;
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        TestRunner.run(suite());
    }
    
    public void testFindExamplesColorPicker() {
        Collection result = getUsers("examples.colorpicker");
        compare(result, USAGES_COLOR_PICKER);
    }

    public void testFindExamplesImageViewer() {
        Collection result = getUsers("examples.imageviewer");
        compare(result, USAGES_IMAGE_VIEWER);
    }
    
    public void testFindExamplesTextEditor() {
        Collection result = getUsers("examples.texteditor");
        compare(result, USAGES_TEXT_EDITOR);
    }
    
    public void testFindExamples() {
        Collection result = getUsers("examples");
        compare(result, USAGES_EXAMPLES);
    }
    
    private Collection getUsers(String className) {
        JavaPackage pckg = (JavaPackage) JavaMetamodel.getManager().getDefaultExtent().getJavaPackage().resolvePackage(className);
        assertNotNull(pckg);
        return pckg.getReferences();
    }
    
    private void compare(Collection col, String[] classNames) {
        FindUtils.compare(col, classNames, getLog());
    }
}
