/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * FindUtils.java
 *
 * Created on 30. leden 2004, 13:28
 */

package org.netbeans.jmi.javamodel.usages;

import java.io.*;
import java.util.*;
import junit.framework.AssertionFailedError;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.junit.AssertionFailedErrorException;

/**
 *
 * @author  Jan Becicka
 */
public class FindUtils {
    
    public static Collection getImmediateComposites(Collection col) {
        List l = new ArrayList();
        
        Iterator i = col.iterator();
        
        while (i.hasNext()) {
            l.add(((MultipartId)i.next()).refImmediateComposite());
        }
        return l;
    }
    
    public static void compare(Collection col, String[] classNames, PrintStream log) {
        
        col = getImmediateComposites(col);
        
        Collections.sort((List) col, new Comparator() {
            public int compare(Object o1, Object o2) {
                return ((Comparable) o1.getClass().getName()).compareTo(o2.getClass().getName());
            }
        });
        
        log.println("Expected number of usages: " + classNames.length);
        log.println("Total usages found: " + col.size());
        log.println("\nExpected usage                       \tFound usage");
        log.println("======================================================");
        boolean passed=true;
        int i=0;
        try {
            for (Iterator it = col.iterator(); it.hasNext() && i<classNames.length; i++) {
                Object o = it.next();
                if (! Class.forName("org.netbeans.jmi.javamodel." + classNames[i]).isInstance(o)) {
                    passed = false;
                }
                log.println("MultipartId in " + classNames[i] + "\t Multipartid in " + o.getClass().getName());
            }
            if (i != classNames.length) {
                passed = false;
            }
        } catch (ClassNotFoundException ex) {
            throw new AssertionFailedErrorException(ex);
        }
        if (!passed) {
            throw new AssertionFailedError("Test failed, see log file for details");
        }
    }    
}
    

