/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.parsing;

import java.util.List;

import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;

/** 
 * @author Jan Becicka
 */
public class ParserErrorsTest extends NbTestCase {
   
    /** Need to be defined because of JUnit */
    public ParserErrorsTest(String name) {
        super(name);
        
    } 
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new ParserErrorsTest("testSyntaxErrors"));
        suite.addTest(new ParserErrorsTest("testSemanticErrors"));
//        suite.addTest(new ParserErrorsTest("testWarnings"));
        return suite;
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        TestRunner.run(suite());
    }

    protected void setUp() {
    }
    
    public void testSyntaxErrors() {
        JavaClass clazz = Utility.findClass("org.netbeans.test.parser.SyntaxError");
        Resource res = clazz.getResource();
        List errors = res.getErrors();
        assertEquals(1, errors.size());
        ErrorInfo error = (ErrorInfo) errors.iterator().next();
        assertEquals(9, error.getLineNumber());
        assertEquals("';' expected", error.getDescription());
        assertEquals(ErrorTypeEnum.ERROR, error.getSeverity());
        assertEquals(12, error.getColumn());
    }
    
    public void testSemanticErrors() {
        JavaClass clazz = Utility.findClass("org.netbeans.test.parser.SemanticError");
        Resource res = clazz.getResource();
        List errors = res.getErrors();
        assertEquals(1, errors.size());
        ErrorInfo error = (ErrorInfo) errors.iterator().next();
        assertEquals(7, error.getLineNumber());
//        assertEquals("cannot find symbol symbol : class JFrame location: class org.netbeans.test.parser.SemanticError", error.getDescription());
        assertEquals(ErrorTypeEnum.ERROR, error.getSeverity());
        assertEquals(13, error.getColumn());
    }
    
//    public void testWarnings() {
//        JavaClass clazz = Utility.findClass("org.netbeans.test.parser.Warning");
//        Resource res = clazz.getResource();
//        List errors = res.getErrors();
//        assertEquals(1, errors.size());
//        ErrorInfo error = (ErrorInfo) errors.iterator().next();
//        assertEquals(0, error.getLineNumber());
//        assertEquals(null, error.getDescription());
//        assertEquals(ErrorTypeEnum.ERROR, error.getSeverity());
//        assertEquals(0, error.getColumn());
//    }

}
