/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *  
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *   
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.jmi.javamodel;

/**
 * Array class proxy interface.
 * Represents Java arrays. It is a typed element, where type means type of 
 * individual elements of the array. So the type of int[][] is int[] and its 
 * type is int.
 *  
 * <p><em><strong>Note:</strong> This type should not be subclassed or implemented 
 * by clients. It is generated from a MOF metamodel and automatically implemented 
 * by MDR (see <a href="http://mdr.netbeans.org/">mdr.netbeans.org</a>).</em></p>
 */
public interface ArrayClass extends javax.jmi.reflect.RefClass {
    /**
     * The default factory operation used to create an instance object.
     * @return The created instance object.
     */
    public Array createArray();
    /**
     * Creates an instance object having attributes initialized by the passed 
     * values.
     * @param name Name of this element.
     * @param contents List of features defined in the class represented by this 
     * object.
     * @param superClassName 
     * @param interfaceNames 
     * @return The created instance object.
     */
    public Array createArray(java.lang.String name, java.util.List/*<org.netbeans.jmi.javamodel.ClassMember>*/ contents, org.netbeans.jmi.javamodel.MultipartId superClassName, java.util.List/*<org.netbeans.jmi.javamodel.MultipartId>*/ interfaceNames);
    /**
     * Resolves a type by its name taking the current classpath into account when 
     * resolving classes.
     * @param name Name of the type to be resolved.
     * @return Resolves a type by its name taking the current classpath into account 
     * when resolving classes.
     */
    public org.netbeans.jmi.javamodel.Type resolve(java.lang.String name);
    /**
     * Returns (and creates if necessary) an array of a given type.
     * @param type 
     * @return Returns (and creates if necessary) an array of a given type.
     */
    public org.netbeans.jmi.javamodel.Array resolveArray(org.netbeans.jmi.javamodel.Type type);
}
