/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *  
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *   
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.jmi.javamodel;

/**
 * ClassDefinition object instance interface.
 * Root class for feature containers - classes, interfaces, enums, annotation 
 * types. This class is not abstract since its instances are used to represent 
 * annonymous classes.
 *  
 * <p><em><strong>Note:</strong> This type should not be subclassed or implemented 
 * by clients. It is generated from a MOF metamodel and automatically implemented 
 * by MDR (see <a href="http://mdr.netbeans.org/">mdr.netbeans.org</a>).</em></p>
 */
public interface ClassDefinition extends org.netbeans.jmi.javamodel.Type, org.netbeans.jmi.javamodel.Element {
    /**
     * Returns field defined by this class (or its supertypes if includeSupertypes 
     * parameter is set to true) that matches the name provided.
     * @param name Name of the field to be returned.
     * @param includeSupertypes Indicates whether this operation should look for 
     * the element in superclasses.
     * @return Returns field defined by this class (or its supertypes if includeSupertypes 
     * parameter is set to true) that matches the name provided.
     */
    public org.netbeans.jmi.javamodel.Field getField(java.lang.String name, boolean includeSupertypes);
    /**
     * Returns method defined by this class (or its supertypes if includeSupertypes 
     * parameter is set to true) that matches the provided signature.
     * @param name Name of the method to be returned.
     * @param parameters List of parameter types of the method to be returned.
     * @param includeSupertypes Indicates whether this operation should look for 
     * the element in superclasses.
     * @return Returns method defined by this class (or its supertypes if includeSupertypes 
     * parameter is set to true) that matches the provided signature.
     */
    public org.netbeans.jmi.javamodel.Method getMethod(java.lang.String name, java.util.List/*<org.netbeans.jmi.javamodel.Type>*/ parameters, boolean includeSupertypes);
    /**
     * Returns innerclass defined by this class (or its supertypes if includeSupertypes 
     * parameter is set to true) that matches the provided simple name.
     * @param simpleName Simple name of the class to be returned.
     * @param includeSupertypes Indicates whether this operation should look for 
     * the element in superclasses.
     * @return Returns innerclass defined by this class (or its supertypes if 
     * includeSupertypes parameter is set to true) that matches the provided simple 
     * name.
     */
    public org.netbeans.jmi.javamodel.JavaClass getInnerClass(java.lang.String simpleName, boolean includeSupertypes);
    /**
     * Returns constructor that matches a given set of parameter types. Searches 
     * in super types if desired.
     * @param parameters List of parameter types.
     * @param includeSupertypes Indicates whether this operation should look for 
     * the constructor also in superclasses.
     * @return Returns constructor that matches a given set of parameter types. 
     * Searches in super types if desired.
     */
    public org.netbeans.jmi.javamodel.Constructor getConstructor(java.util.List/*<org.netbeans.jmi.javamodel.Type>*/ parameters, boolean includeSupertypes);
    /**
     * @param javaClass 
     * @return 
     */
    public boolean isSubTypeOf(org.netbeans.jmi.javamodel.ClassDefinition javaClass);
    /**
     * Returns the value of attribute contents.
     * List of features defined in the class represented by this object.
     * @return Value of contents attribute. Element type: {@link org.netbeans.jmi.javamodel.ClassMember}
     */
    public java.util.List/*<org.netbeans.jmi.javamodel.ClassMember>*/ getContents();
    /**
     * Returns the value of attribute superClassName.
     * @return Value of attribute superClassName.
     */
    public org.netbeans.jmi.javamodel.MultipartId getSuperClassName();
    /**
     * Sets the value of superClassName attribute. See {@link #getSuperClassName} 
     * for description on the attribute.
     * @param newValue New value to be set.
     */
    public void setSuperClassName(org.netbeans.jmi.javamodel.MultipartId newValue);
    /**
     * Returns the value of attribute interfaceNames.
     * @return Value of interfaceNames attribute. Element type: {@link org.netbeans.jmi.javamodel.MultipartId}
     */
    public java.util.List/*<org.netbeans.jmi.javamodel.MultipartId>*/ getInterfaceNames();
    /**
     * Returns the value of attribute features.
     * @return Value of features attribute. Element type: {@link org.netbeans.jmi.javamodel.Feature}
     */
    public java.util.List/*<org.netbeans.jmi.javamodel.Feature>*/ getFeatures();
    /**
     * Returns the value of reference interfaces.
     * Interfaces that a given class (or interface) implements (or extends).
     * @return Value of reference interfaces. Element type: {@link org.netbeans.jmi.javamodel.JavaClass}
     */
    public java.util.List/*<org.netbeans.jmi.javamodel.JavaClass>*/ getInterfaces();
    /**
     * Returns the value of reference superClass.
     * Navigates to the super class of a given class. Interfaces have no superclass. 
     * All the extended interfaces are associated with an interface using Implements 
     * association.
     * @return Value of reference superClass.
     */
    public org.netbeans.jmi.javamodel.JavaClass getSuperClass();
    /**
     * Sets the value of reference superClass. See {@link #getSuperClass} for 
     * description on the reference.
     * @param newValue New value to be set.
     */
    public void setSuperClass(org.netbeans.jmi.javamodel.JavaClass newValue);
}
