/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *  
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *   
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.jmi.javamodel;

/**
 * ClassMember object instance interface.
 * Class representing Java class features (elements, that can be directly 
 * contained in a class - e.g. methods, constructors, fields, etc.)
 *  
 * <p><em><strong>Note:</strong> This type should not be subclassed or implemented 
 * by clients. It is generated from a MOF metamodel and automatically implemented 
 * by MDR (see <a href="http://mdr.netbeans.org/">mdr.netbeans.org</a>).</em></p>
 */
public interface ClassMember extends org.netbeans.jmi.javamodel.AnnotableElement {
    /**
     * Returns the declaring class of this feature.
     * @return Returns the declaring class of this feature.
     */
    public org.netbeans.jmi.javamodel.ClassDefinition getDeclaringClass();
    /**
     * Returns the value of attribute modifiers.
     * Modifiers of the features.
     * @return Value of attribute modifiers.
     */
    public int getModifiers();
    /**
     * Sets the value of modifiers attribute. See {@link #getModifiers} for description 
     * on the attribute.
     * @param newValue New value to be set.
     */
    public void setModifiers(int newValue);
    /**
     * Returns the value of attribute javadocText.
     * Textual representation of feature's JavaDoc.
     * @return Value of attribute javadocText.
     */
    public java.lang.String getJavadocText();
    /**
     * Sets the value of javadocText attribute. See {@link #getJavadocText} for 
     * description on the attribute.
     * @param newValue New value to be set.
     */
    public void setJavadocText(java.lang.String newValue);
    /**
     * Returns the value of attribute javadoc.
     * Object representation of feature's JavaDoc.
     * @return Value of attribute javadoc.
     */
    public org.netbeans.jmi.javamodel.JavaDoc getJavadoc();
    /**
     * Sets the value of javadoc attribute. See {@link #getJavadoc} for description 
     * on the attribute.
     * @param newValue New value to be set.
     */
    public void setJavadoc(org.netbeans.jmi.javamodel.JavaDoc newValue);
}
