/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *  
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *   
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.jmi.javamodel;

/**
 * Operator enumeration class implementation.
 * Enumeration of Java operators.
 *  
 * <p><em><strong>Note:</strong> This type should not be subclassed or implemented 
 * by clients. It is generated from a MOF metamodel and automatically implemented 
 * by MDR (see <a href="http://mdr.netbeans.org/">mdr.netbeans.org</a>).</em></p>
 */
public final class OperatorEnum implements Operator {
    /**
     * Enumeration constant corresponding to literal assign.
     */
    public static final OperatorEnum ASSIGN = new OperatorEnum("assign");
    /**
     * Enumeration constant corresponding to literal gt.
     */
    public static final OperatorEnum GT = new OperatorEnum("gt");
    /**
     * Enumeration constant corresponding to literal lt.
     */
    public static final OperatorEnum LT = new OperatorEnum("lt");
    /**
     * Enumeration constant corresponding to literal not.
     */
    public static final OperatorEnum NOT = new OperatorEnum("not");
    /**
     * Enumeration constant corresponding to literal equal.
     */
    public static final OperatorEnum EQUAL = new OperatorEnum("equal");
    /**
     * Enumeration constant corresponding to literal lte.
     */
    public static final OperatorEnum LTE = new OperatorEnum("lte");
    /**
     * Enumeration constant corresponding to literal gte.
     */
    public static final OperatorEnum GTE = new OperatorEnum("gte");
    /**
     * Enumeration constant corresponding to literal nequal.
     */
    public static final OperatorEnum NEQUAL = new OperatorEnum("nequal");
    /**
     * Enumeration constant corresponding to literal land.
     */
    public static final OperatorEnum LAND = new OperatorEnum("land");
    /**
     * Enumeration constant corresponding to literal lor.
     */
    public static final OperatorEnum LOR = new OperatorEnum("lor");
    /**
     * Enumeration constant corresponding to literal inc.
     */
    public static final OperatorEnum INC = new OperatorEnum("inc");
    /**
     * Enumeration constant corresponding to literal dec.
     */
    public static final OperatorEnum DEC = new OperatorEnum("dec");
    /**
     * Enumeration constant corresponding to literal plus.
     */
    public static final OperatorEnum PLUS = new OperatorEnum("plus");
    /**
     * Enumeration constant corresponding to literal minus.
     */
    public static final OperatorEnum MINUS = new OperatorEnum("minus");
    /**
     * Enumeration constant corresponding to literal multi.
     */
    public static final OperatorEnum MULTI = new OperatorEnum("multi");
    /**
     * Enumeration constant corresponding to literal div.
     */
    public static final OperatorEnum DIV = new OperatorEnum("div");
    /**
     * Enumeration constant corresponding to literal and.
     */
    public static final OperatorEnum AND = new OperatorEnum("and");
    /**
     * Enumeration constant corresponding to literal or.
     */
    public static final OperatorEnum OR = new OperatorEnum("or");
    /**
     * Enumeration constant corresponding to literal xor.
     */
    public static final OperatorEnum XOR = new OperatorEnum("xor");
    /**
     * Enumeration constant corresponding to literal mod.
     */
    public static final OperatorEnum MOD = new OperatorEnum("mod");
    /**
     * Enumeration constant corresponding to literal lshift.
     */
    public static final OperatorEnum LSHIFT = new OperatorEnum("lshift");
    /**
     * Enumeration constant corresponding to literal rshift.
     */
    public static final OperatorEnum RSHIFT = new OperatorEnum("rshift");
    /**
     * Enumeration constant corresponding to literal urshift.
     */
    public static final OperatorEnum URSHIFT = new OperatorEnum("urshift");
    /**
     * Enumeration constant corresponding to literal plusassign.
     */
    public static final OperatorEnum PLUSASSIGN = new OperatorEnum("plusassign");
    /**
     * Enumeration constant corresponding to literal minusassign.
     */
    public static final OperatorEnum MINUSASSIGN = new OperatorEnum("minusassign");
    /**
     * Enumeration constant corresponding to literal multiassign.
     */
    public static final OperatorEnum MULTIASSIGN = new OperatorEnum("multiassign");
    /**
     * Enumeration constant corresponding to literal divassign.
     */
    public static final OperatorEnum DIVASSIGN = new OperatorEnum("divassign");
    /**
     * Enumeration constant corresponding to literal andassign.
     */
    public static final OperatorEnum ANDASSIGN = new OperatorEnum("andassign");
    /**
     * Enumeration constant corresponding to literal orassign.
     */
    public static final OperatorEnum ORASSIGN = new OperatorEnum("orassign");
    /**
     * Enumeration constant corresponding to literal xorassign.
     */
    public static final OperatorEnum XORASSIGN = new OperatorEnum("xorassign");
    /**
     * Enumeration constant corresponding to literal modassign.
     */
    public static final OperatorEnum MODASSIGN = new OperatorEnum("modassign");
    /**
     * Enumeration constant corresponding to literal lshiftassign.
     */
    public static final OperatorEnum LSHIFTASSIGN = new OperatorEnum("lshiftassign");
    /**
     * Enumeration constant corresponding to literal rshiftassign.
     */
    public static final OperatorEnum RSHIFTASSIGN = new OperatorEnum("rshiftassign");
    /**
     * Enumeration constant corresponding to literal urshiftassign.
     */
    public static final OperatorEnum URSHIFTASSIGN = new OperatorEnum("urshiftassign");
    /**
     * Enumeration constant corresponding to literal comp.
     */
    public static final OperatorEnum COMP = new OperatorEnum("comp");
    /**
     * Enumeration constant corresponding to literal instanceof.
     */
    public static final OperatorEnum INSTANCEOF = new OperatorEnum("instanceof");

    private static final java.util.List typeName;
    private final java.lang.String literalName;

    static {
        java.util.ArrayList temp = new java.util.ArrayList();
        temp.add("JavaModel");
        temp.add("Operator");
        typeName = java.util.Collections.unmodifiableList(temp);
    }

    private OperatorEnum(java.lang.String literalName) {
        this.literalName = literalName;
    }

    /**
     * Returns fully qualified name of the enumeration type.
     * @return List containing all parts of the fully qualified name.
     */
    public java.util.List refTypeName() {
        return typeName;
    }

    /**
     * Returns a string representation of the enumeration value.
     * @return A string representation of the enumeration value.
     */
    public java.lang.String toString() {
        return literalName;
    }

    /**
     * Returns a hash code for this the enumeration value.
     * @return A hash code for this enumeration value.
     */
    public int hashCode() {
        return literalName.hashCode();
    }

    /**
     * Indicates whether some other object is equal to this enumeration value.
     * @param o The reference object with which to compare.
     * @return true if the other object is the enumeration of the same type and 
     * of the same value.
     */
    public boolean equals(java.lang.Object o) {
        if (o instanceof OperatorEnum) return (o == this);
        else if (o instanceof Operator) return (o.toString().equals(literalName));
        else return ((o instanceof javax.jmi.reflect.RefEnum) && ((javax.jmi.reflect.RefEnum) o).refTypeName().equals(typeName) && o.toString().equals(literalName));
    }

    /**
     * Translates literal name to correspondent enumeration value.
     * @param name Enumeration literal.
     * @return Enumeration value corresponding to the passed literal.
     */
    public static Operator forName(java.lang.String name) {
        if (name.equals("assign")) return ASSIGN;
        if (name.equals("gt")) return GT;
        if (name.equals("lt")) return LT;
        if (name.equals("not")) return NOT;
        if (name.equals("equal")) return EQUAL;
        if (name.equals("lte")) return LTE;
        if (name.equals("gte")) return GTE;
        if (name.equals("nequal")) return NEQUAL;
        if (name.equals("land")) return LAND;
        if (name.equals("lor")) return LOR;
        if (name.equals("inc")) return INC;
        if (name.equals("dec")) return DEC;
        if (name.equals("plus")) return PLUS;
        if (name.equals("minus")) return MINUS;
        if (name.equals("multi")) return MULTI;
        if (name.equals("div")) return DIV;
        if (name.equals("and")) return AND;
        if (name.equals("or")) return OR;
        if (name.equals("xor")) return XOR;
        if (name.equals("mod")) return MOD;
        if (name.equals("lshift")) return LSHIFT;
        if (name.equals("rshift")) return RSHIFT;
        if (name.equals("urshift")) return URSHIFT;
        if (name.equals("plusassign")) return PLUSASSIGN;
        if (name.equals("minusassign")) return MINUSASSIGN;
        if (name.equals("multiassign")) return MULTIASSIGN;
        if (name.equals("divassign")) return DIVASSIGN;
        if (name.equals("andassign")) return ANDASSIGN;
        if (name.equals("orassign")) return ORASSIGN;
        if (name.equals("xorassign")) return XORASSIGN;
        if (name.equals("modassign")) return MODASSIGN;
        if (name.equals("lshiftassign")) return LSHIFTASSIGN;
        if (name.equals("rshiftassign")) return RSHIFTASSIGN;
        if (name.equals("urshiftassign")) return URSHIFTASSIGN;
        if (name.equals("comp")) return COMP;
        if (name.equals("instanceof")) return INSTANCEOF;
        throw new java.lang.IllegalArgumentException("Unknown literal name '" + name + "' for enumeration 'JavaModel.Operator'");
    }
    /**
     * Resolves serialized instance of enumeration value.
     * @return Resolved enumeration value.
     */
    protected java.lang.Object readResolve() throws java.io.ObjectStreamException {
        try {
            return forName(literalName);
        } catch (java.lang.IllegalArgumentException e) {
            throw new java.io.InvalidObjectException(e.getMessage());
        }
    }
}
