/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *  
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *   
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.jmi.javamodel;

/**
 * PrimitiveType class proxy interface.
 * Class representing Java primitive types. Name of the primitive type is 
 * immutable and is derived from the kind attribute that determines which 
 * primitive type this object represents. The name always matches the Java 
 * keyword representing the primitive type in Java source code. Set of instances 
 * of this object is given and the instances cannot be created explicitly. 
 * One can get all instances of a primitive type using refAllOfClass or TypeClass.resolveType 
 * methods.
 *  
 * <p><em><strong>Note:</strong> This type should not be subclassed or implemented 
 * by clients. It is generated from a MOF metamodel and automatically implemented 
 * by MDR (see <a href="http://mdr.netbeans.org/">mdr.netbeans.org</a>).</em></p>
 */
public interface PrimitiveTypeClass extends javax.jmi.reflect.RefClass {
    /**
     * The default factory operation used to create an instance object.
     * @return The created instance object.
     */
    public PrimitiveType createPrimitiveType();
    /**
     * Creates an instance object having attributes initialized by the passed 
     * values.
     * @param name Name of this element.
     * @param kind Read-only attribute that determines what Java primitive type 
     * this object represents.
     * @return The created instance object.
     */
    public PrimitiveType createPrimitiveType(java.lang.String name, org.netbeans.jmi.javamodel.PrimitiveTypeKind kind);
    /**
     * Resolves a type by its name taking the current classpath into account when 
     * resolving classes.
     * @param name Name of the type to be resolved.
     * @return Resolves a type by its name taking the current classpath into account 
     * when resolving classes.
     */
    public org.netbeans.jmi.javamodel.Type resolve(java.lang.String name);
}
