/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *  
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *   
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.jmi.javamodel;

/**
 * ResolvesTo association proxy interface.
 *  
 * <p><em><strong>Note:</strong> This type should not be subclassed or implemented 
 * by clients. It is generated from a MOF metamodel and automatically implemented 
 * by MDR (see <a href="http://mdr.netbeans.org/">mdr.netbeans.org</a>).</em></p>
 */
public interface ResolvesTo extends javax.jmi.reflect.RefAssociation {
    /**
     * Queries whether a link currently exists between a given pair of instance 
     * objects in the associations link set.
     * @param references Value of the first association end.
     * @param element Value of the second association end.
     * @return Returns true if the queried link exists.
     */
    public boolean exists(org.netbeans.jmi.javamodel.ElementReference references, org.netbeans.jmi.javamodel.NamedElement element);
    /**
     * Queries the instance objects that are related to a particular instance 
     * object by a link in the current associations link set.
     * @param element Required value of the second association end.
     * @return Collection of related objects.
     */
    public java.util.Collection getReferences(org.netbeans.jmi.javamodel.NamedElement element);
    /**
     * Queries the instance object that is related to a particular instance object 
     * by a link in the current associations link set.
     * @param references Required value of the first association end.
     * @return Related object or <code>null</code> if none exists.
     */
    public org.netbeans.jmi.javamodel.NamedElement getElement(org.netbeans.jmi.javamodel.ElementReference references);
    /**
     * Creates a link between the pair of instance objects in the associations 
     * link set.
     * @param references Value of the first association end.
     * @param element Value of the second association end.
     */
    public boolean add(org.netbeans.jmi.javamodel.ElementReference references, org.netbeans.jmi.javamodel.NamedElement element);
    /**
     * Removes a link between a pair of instance objects in the current associations 
     * link set.
     * @param references Value of the first association end.
     * @param element Value of the second association end.
     */
    public boolean remove(org.netbeans.jmi.javamodel.ElementReference references, org.netbeans.jmi.javamodel.NamedElement element);
}
