/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *  
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *   
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.jmi.javamodel;

/**
 * Resource object instance interface.
 * Class representing a metadata source (source or class file).
 *  
 * <p><em><strong>Note:</strong> This type should not be subclassed or implemented 
 * by clients. It is generated from a MOF metamodel and automatically implemented 
 * by MDR (see <a href="http://mdr.netbeans.org/">mdr.netbeans.org</a>).</em></p>
 */
public interface Resource extends org.netbeans.jmi.javamodel.NamedElement {
    /**
     * @return 
     */
    public java.lang.String getSourceText();
    /**
     * @param identifier 
     * @return 
     */
    public boolean containsIdentifier(java.lang.String identifier);
    /**
     * @return 
     */
    public int getStatus();
    /**
     * @return 
     */
    public java.util.List getErrors();
    /**
     * Returns element at a given offset in the source file.
     * @param offset 
     * @return Returns element at a given offset in the source file.
     */
    public org.netbeans.jmi.javamodel.Element getElementByOffset(int offset);
    /**
     * Returns list of all classes that contain main method - i.e. are runnable. 
     * The primary class (class with the same name as the resource) is the first 
     * one in the list (if applicable).
     * @return Returns list of all classes that contain main method - i.e. are 
     * runnable. The primary class (class with the same name as the resource) 
     * is the first one in the list (if applicable).
     */
    public java.util.List getMain();
    /**
     * Adds a new {@link Import} into this resource. This method ensures that 
     * the imports are sorted correctly and that an import is not present twice 
     * in the resource. The method may also convert class import to package import 
     * and do other import optimizations.
     * The method returns true if the set of imports in the resource was chang
     * ed as a result of this operation. Otherwise (if the import was already pr
     * esent) it returns false.
     * @param importToAdd Import to be added to resource.
     * @return Adds a new {@link Import} into this resource. This method ensures 
     * that the imports are sorted correctly and that an import is not present 
     * twice in the resource. The method may also convert class import to package 
     * import and do other import optimizations.
     * The method returns true if the set of imports in the resource was changed 
     * as a result of this operation. Otherwise (if the import was already pres
     * ent) it returns false.
     */
    public boolean addImport(org.netbeans.jmi.javamodel.Import importToAdd);
    /**
     * Returns the value of attribute timestamp.
     * Timestamp of the resource.
     * @return Value of attribute timestamp.
     */
    public long getTimestamp();
    /**
     * Sets the value of timestamp attribute. See {@link #getTimestamp} for description 
     * on the attribute.
     * @param newValue New value to be set.
     */
    public void setTimestamp(long newValue);
    /**
     * Returns the value of attribute classifiers.
     * List of classifiers defined in this resource.
     * @return Value of classifiers attribute. Element type: {@link org.netbeans.jmi.javamodel.JavaClass}
     */
    public java.util.List/*<org.netbeans.jmi.javamodel.JavaClass>*/ getClassifiers();
    /**
     * Returns the value of attribute imports.
     * List of imports declared in this resource.
     * @return Value of imports attribute. Element type: {@link org.netbeans.jmi.javamodel.Import}
     */
    public java.util.List/*<org.netbeans.jmi.javamodel.Import>*/ getImports();
    /**
     * Returns the value of attribute packageName.
     * Package associated with this resource (using package keyword).
     * @return Value of attribute packageName.
     */
    public java.lang.String getPackageName();
    /**
     * Sets the value of packageName attribute. See {@link #getPackageName} for 
     * description on the attribute.
     * @param newValue New value to be set.
     */
    public void setPackageName(java.lang.String newValue);
    /**
     * Returns the value of attribute packageIdentifier.
     * @return Value of attribute packageIdentifier.
     */
    public org.netbeans.jmi.javamodel.MultipartId getPackageIdentifier();
    /**
     * Sets the value of packageIdentifier attribute. See {@link #getPackageIdentifier} 
     * for description on the attribute.
     * @param newValue New value to be set.
     */
    public void setPackageIdentifier(org.netbeans.jmi.javamodel.MultipartId newValue);
    /**
     * Returns the value of attribute packageAnnotations.
     * @return Value of packageAnnotations attribute. Element type: {@link org.netbeans.jmi.javamodel.Annotation}
     */
    public java.util.List/*<org.netbeans.jmi.javamodel.Annotation>*/ getPackageAnnotations();
}
