/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *  
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *   
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.jmi.javamodel;

/**
 * Resource class proxy interface.
 * Class representing a metadata source (source or class file).
 *  
 * <p><em><strong>Note:</strong> This type should not be subclassed or implemented 
 * by clients. It is generated from a MOF metamodel and automatically implemented 
 * by MDR (see <a href="http://mdr.netbeans.org/">mdr.netbeans.org</a>).</em></p>
 */
public interface ResourceClass extends javax.jmi.reflect.RefClass {
    /**
     * The default factory operation used to create an instance object.
     * @return The created instance object.
     */
    public Resource createResource();
    /**
     * Creates an instance object having attributes initialized by the passed 
     * values.
     * @param name Name of this element.
     * @param timestamp Timestamp of the resource.
     * @param classifiers List of classifiers defined in this resource.
     * @param imports List of imports declared in this resource.
     * @param packageName Package associated with this resource (using package 
     * keyword).
     * @param packageIdentifier 
     * @param packageAnnotations 
     * @return The created instance object.
     */
    public Resource createResource(java.lang.String name, long timestamp, java.util.List/*<org.netbeans.jmi.javamodel.JavaClass>*/ classifiers, java.util.List/*<org.netbeans.jmi.javamodel.Import>*/ imports, java.lang.String packageName, org.netbeans.jmi.javamodel.MultipartId packageIdentifier, java.util.List/*<org.netbeans.jmi.javamodel.Annotation>*/ packageAnnotations);
    /**
     * Returns a resource of a given name. If the resource does not exist then 
     * it is created (if the create parameter is set to true) or null is returned.
     * @param name Name of the resource to be resolved.
     * @param create Indicates whether a new resource with a given name should 
     * be created if it cannot be found.
     * @return Returns a resource of a given name. If the resource does not exist 
     * then it is created (if the create parameter is set to true) or null is 
     * returned.
     */
    public org.netbeans.jmi.javamodel.Resource resolveResource(java.lang.String name, boolean create);
}
