/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *  
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *   
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.jmi.javamodel;

/**
 * Throws association proxy interface.
 * Associates callable features with the exceptions they throw.
 *  
 * <p><em><strong>Note:</strong> This type should not be subclassed or implemented 
 * by clients. It is generated from a MOF metamodel and automatically implemented 
 * by MDR (see <a href="http://mdr.netbeans.org/">mdr.netbeans.org</a>).</em></p>
 */
public interface Throws extends javax.jmi.reflect.RefAssociation {
    /**
     * Queries whether a link currently exists between a given pair of instance 
     * objects in the associations link set.
     * @param callableFeatures Value of the first association end.
     * @param exceptions Value of the second association end.
     * @return Returns true if the queried link exists.
     */
    public boolean exists(org.netbeans.jmi.javamodel.CallableFeature callableFeatures, org.netbeans.jmi.javamodel.JavaClass exceptions);
    /**
     * Queries the instance objects that are related to a particular instance 
     * object by a link in the current associations link set.
     * @param exceptions Required value of the second association end.
     * @return Collection of related objects.
     */
    public java.util.Collection getCallableFeatures(org.netbeans.jmi.javamodel.JavaClass exceptions);
    /**
     * Queries the instance objects that are related to a particular instance 
     * object by a link in the current associations link set.
     * @param callableFeatures Required value of the first association end.
     * @return List of related objects.
     */
    public java.util.List getExceptions(org.netbeans.jmi.javamodel.CallableFeature callableFeatures);
    /**
     * Creates a link between the pair of instance objects in the associations 
     * link set.
     * @param callableFeatures Value of the first association end.
     * @param exceptions Value of the second association end.
     */
    public boolean add(org.netbeans.jmi.javamodel.CallableFeature callableFeatures, org.netbeans.jmi.javamodel.JavaClass exceptions);
    /**
     * Removes a link between a pair of instance objects in the current associations 
     * link set.
     * @param callableFeatures Value of the first association end.
     * @param exceptions Value of the second association end.
     */
    public boolean remove(org.netbeans.jmi.javamodel.CallableFeature callableFeatures, org.netbeans.jmi.javamodel.JavaClass exceptions);
}
