/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * ClassMemberRelatedItemProvider.java
 *
 * Created on September 23, 2004, 11:56 PM
 */

package org.netbeans.modules.java.navigation;

import org.netbeans.jmi.javamodel.*;
import org.netbeans.modules.java.JavaDataObject;

import java.util.*;
import org.netbeans.modules.java.navigation.jmi.Hacks;
import org.netbeans.modules.java.navigation.spi.RelatedItemProviderSupport;

/**
 * Finds the Element represented by the activated node, if any, and provides a Collection of ClassMember objects which
 * reference that element (method callers, etc.).
 *
 * @author Tim Boudreau
 */
public final class ClassMemberRelatedItemProvider extends RelatedItemProviderSupport.ActiveNodeSupport {
    private final JavaDataObject jdo;

    /**
     * Creates a new instance of ClassMemberRelatedItemProvider
     */
    ClassMemberRelatedItemProvider (JavaDataObject jdo) {
        super ( false );
        this.jdo = jdo;
    }
    
    protected Object getPrimaryItemFromNodes (org.openide.nodes.Node[] n) {
        if ( n == null || n.length > 1 || n.length == 0 ) {
            return null;
        } else {
            Element elem = Hacks.getElementForNode ( n[ 0 ] );
            if ( elem != null && !elem.isValid () ) {
                elem = null;
            }
            return !active() ? null : elem;
        }
    }

    private Object relItem = null; //XXX used by toString for diagnostics
    static final boolean USE_RELATED_ITEMS = 
            Boolean.getBoolean("nb.navigator.relatedItems");

    protected Collection collectRelatedItems (Object o) {
        // [dafe] temporarily enabled only on option, bcs of performance and usability reasons,
        // must be resolved first
        if (USE_RELATED_ITEMS) { //TDB:  Make it possible to use this
            if ( o != null && o instanceof NamedElement ) {
                relItem = o;
                Collection result = Hacks.findUsagesOfElement ( jdo,
                        (NamedElement) o, this );

                relItem = null;
                return result;
            } else {
                return Collections.EMPTY_SET;
            }
        } else {
            return Collections.EMPTY_LIST;
        }
    }

    /**
     * Make this public - we will use this object as an argument to the lookup method, so it can check if it should
     * abort because the model has changed.
     */
    public boolean active () {
        return super.isActive ();
    }

    public String toString () {
        return getClass ().getName () + " currently collecting for " + relItem;
    }
}
