/*
* The contents of this file are subject to the terms of the Common Development
* and Distribution License (the License). You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the License at http://www.netbeans.org/cddl.html
* or http://www.netbeans.org/cddl.txt.
* 
* When distributing Covered Code, include this CDDL Header Notice in each file
* and include the License file at http://www.netbeans.org/cddl.txt.
* If applicable, add the following below the CDDL Header, with the fields
* enclosed by brackets [] replaced by your own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* The Original Software is NetBeans. The Initial Developer of the Original
* Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
* Microsystems, Inc. All Rights Reserved.
*/
/*
 * NaturalSortComparator.java
 *
 * Created on September 24, 2004, 3:01 PM
 */

package org.netbeans.modules.java.navigation;

import org.netbeans.jmi.javamodel.*;
import org.openide.*;

import java.util.*;
import org.netbeans.modules.java.navigation.jmi.JUtils;

/**
 * Comparator which does natural sort of class members, in the order they occur in the source file.
 *
 * @author Tim Boudreau
 */
final class NaturalSortComparator implements Comparator {

    public int compare (Object a, Object b) {
        return offsetFor ( a ) - offsetFor ( b );
    }

    private static int offsetFor (Object o) {
        o = JUtils.unwrap ( o );
        if ( o instanceof Element ) {
            return ( (Element) o ).getStartOffset ();
        } else {
            return 0;
        }
    }

}
