/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * Filtered.java
 *
 * Created on September 11, 2004, 9:47 PM
 */

package org.netbeans.modules.java.navigation.base;

import javax.swing.JComponent;
import javax.swing.event.*;
import java.util.*;


/**
 * Base interface for models which accept filters to limit what objects are presented.  Not to be implemented directly.
 *
 * @author Tim Boudreau
 */
public interface NavigatorModel {
    /**
     * Notifies the model that it has is in use and should, if necessary, listen for changes on the DataObject it
     * represents and propagate those as model changes.
     */
    public void addNotify ();

    /**
     * Notifies the model that it is no longer in use, and should dispose of any cached content and remove any listeners
     * to avoid memory leaks.
     */
    public void removeNotify ();

    /**
     * Returns true if the model is loaded and functional.  Models which load data on a background thread should return
     * false from this property and fire a change event when they become loaded.
     * <p/>
     * Objects which will listen on the model should defer attaching listeners other than change listeners until the
     * model is ready.
     */
    public boolean isReady ();

    /**
     * Add a change listener.  The following states are of interest - isReady, and if the model implements Reorderable,
     * isReorderable().
     * <p/>
     * Objects which will listen on the model should defer attaching listeners other than change listeners until the
     * model is ready.
     * <p/>
     * <i>All change events must be fired on the event dispatch thread</i>
     */
    public void addChangeListener (ChangeListener cl) throws TooManyListenersException;

    /**
     * Remove a change listener.  The following states are of interest - isReady, and if the model implements
     * Reorderable, isReorderable().
     */
    public void removeChangeListener (ChangeListener cl);
    
    /** Provides access to Swing component which purpose is to filter content
     * shown in navigation component.
     * XXX - should be deleted when component handling moves from navigator
     * module to client modules
     * 
     * @return component representing filters.
     */
    public JComponent getFilters ();

}
