/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * ReorderDragAndDropHandler.java
 *
 * Created on September 24, 2004, 10:25 PM
 */

package org.netbeans.modules.java.navigation.base;

import org.openide.awt.*;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import org.netbeans.modules.java.navigation.spi.NavigatorListModel;
import org.netbeans.modules.java.navigation.spi.Reorderable;

/**
 * Drag and drop listener which handles move operations on lists and (eventually) trees.
 *
 * @author Tim Boudreau
 */
class ReorderDragAndDropHandler implements MouseListener, MouseMotionListener {

    private Reorderable getReorderable (Object jc) {
        Reorderable result = null;
        if ( jc instanceof JTree && ( (JTree) jc ).getModel () instanceof Reorderable ) {
            result = (Reorderable) ( (JTree) jc ).getModel ();
        } else if ( jc instanceof JList && ( (JList) jc ).getModel () instanceof Reorderable ) {
            result = (Reorderable) ( (JList) jc ).getModel ();
        }
        return result != null && result.isReorderable () ? result : null;
    }

    private Reorderable currReorderable = null;
    private JComponent target = null;
    private Point dragStart = null;
    private CellRenderer rend = null;

    private void armDrag (JComponent jc, Point p, Reorderable r) {
        if ( jc instanceof JTree && ( (JTree) jc ).getCellRenderer () instanceof CellRenderer ) {
            rend = (CellRenderer) ( (JTree) jc ).getCellRenderer ();
        } else if ( jc instanceof JList && ( (JList) jc ).getCellRenderer () instanceof CellRenderer ) {
            rend = (CellRenderer) ( (JList) jc ).getCellRenderer ();
        } else {
            return;
        }
        currReorderable = r;
        target = jc;
        dragStart = p;
    }

    private void abortDrag () {
        currReorderable = null;
        target = null;
        dragStart = null;
        if ( rend != null ) {
            rend.setShowDragFeedback ( false );
        }
        rend = null;
    }

    private void endDrag (MouseEvent e) {
        if ( target instanceof JTree ) {
            endDragForTree ( e );
        } else {
            endDragForList ( e );
        }
    }

    private Object selectedObjectAt (Point p) {
        if ( target instanceof JTree ) {
            return null; //XXX
        } else if ( target instanceof JList ) {
            JList list = (JList) target;
            int idx = list.locationToIndex ( p );
            if ( idx != -1 && idx < list.getModel ().getSize () ) {
                return list.getModel ().getElementAt ( idx );
            }
        }
        return null;
    }

    private void endDragForTree (MouseEvent e) {
        //XXX not implemented
    }

    private void endDragForList (MouseEvent e) {
        JList list = (JList) target;
        int targetIdx = list.locationToIndex ( e.getPoint () );
        if ( targetIdx == -1 || targetIdx >= list.getModel ().getSize () ) {
            abortDrag ();
            return;
        }
        int sourceIdx = list.locationToIndex ( dragStart );
        if ( sourceIdx == -1 || sourceIdx >= list.getModel ().getSize () ) {
            abortDrag ();
            return;
        }
        if ( sourceIdx == targetIdx ) {
            abortDrag ();
            return;
        }
        Object o = list.getModel ().getElementAt ( sourceIdx );
        String msg = null;
        Cursor cursor = target.getCursor ();
        try {
            target.setCursor ( Cursor.getPredefinedCursor ( Cursor.WAIT_CURSOR ) );
            msg = currReorderable.move ( o, targetIdx );
        } finally {
            target.setCursor ( cursor );
        }
        if ( msg != null ) {
            StatusDisplayer.getDefault ().setStatusText ( msg );
        } else {
            list.setSelectedIndex ( targetIdx );
            Action a = ( (NavigatorListModel) list.getModel () ).getDefaultAction ( o );
            if ( a != null ) {
                a.actionPerformed ( new ActionEvent ( list,
                        ActionEvent.ACTION_PERFORMED, "move" ) ); //NOI18N
            }
        }
        abortDrag ();
    }

    private boolean isActive (MouseEvent e) {
        boolean result = !e.isPopupTrigger () && currReorderable != null && target.contains ( e.getPoint () ) && e.getSource () == target;
        if ( result && target instanceof JList ) {
            JList list = (JList) target;
            Point p = e.getPoint ();
            if ( list.locationToIndex ( p ) == list.locationToIndex ( dragStart ) ) {
                result = false;
            }
        }
        return result;
    }

    public void mousePressed (MouseEvent e) {
        Reorderable r = getReorderable ( e.getSource () );
        if ( r != null ) {
            armDrag ( (JComponent) e.getSource (), e.getPoint (), r );
        }
    }

    public void mouseReleased (MouseEvent e) {
        if ( isActive ( e ) ) {
            endDrag ( e );
        } else {
            abortDrag ();
        }
    }

    public void mouseClicked (MouseEvent e) {
        //do nothing
    }

    public void mouseEntered (MouseEvent e) {
        //do nothing
    }

    public void mouseExited (MouseEvent e) {
        //do nothing
    }

    public void mouseDragged (MouseEvent e) {
        if ( isActive ( e ) ) {
            boolean isNotStartItem = selectedObjectAt ( e.getPoint () ) != selectedObjectAt ( dragStart );
            rend.setShowDragFeedback ( isNotStartItem );
        }
    }

    public void mouseMoved (MouseEvent e) {
        //do nothing
    }
}
