/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * AbstractModel.java
 *
 * Created on September 29, 2004, 2:22 AM
 */

package org.netbeans.modules.java.navigation.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreePath;

/**
 * Base class for model support classes.  Cannot be subclassed outside this
 * package.
 *
 * @author Tim Boudreau
 */
public abstract class AbstractModel {
    
    protected AbstractModel() {
        if (!TreeModelSupport.class.isAssignableFrom(getClass()) && 
            !ListModelSupport.class.isAssignableFrom(getClass())) {
                
            throw new Error ("Only ListModelSupport and TreeModelSupport " + //NOI18N
                "may subclass AbstractModelSupport"); //NOI18N
        }
    }
    
    protected abstract List loadContents();
    
    public final void addNotify() {
        doAddNotify();
        TreeModelSupport owner = getTree();
        if (tree != null) {
//            owner.notifyChildModelAddNotify (this);
        }
    }
    
    abstract void doAddNotify();
    
    protected abstract void removeNotify();
    
    protected abstract List getSearchResults (String partial);
    
    protected abstract boolean isActive();
    
    protected abstract List getList();
    
    protected abstract boolean isReady();
    
    protected abstract void startListening();
    
    protected abstract void stopListening();
    
    protected abstract void addChangeListener( ChangeListener ce ) throws TooManyListenersException;
    
    protected abstract void removeChangeListener( ChangeListener ce );
    
    abstract boolean owns (Object o);
    
    abstract int getSize();
    
    abstract Object getElementAt (int i);
    
    abstract int indexOf (Object o);
    
    AbstractModel findModelFor (Object o, boolean create) {
        return owns (o) ? this : null;
    }
    
    
    private TreeModelSupport tree = null;
    /**
     * Allow some hooks for embedding in an instance of TreeModelSupport.
     */
    void setTree (TreeModelSupport tree) {
        this.tree = tree;
    }
    
    List tempList = null;
    List getLoadingTempList() {
        if (tempList == null) {
            tempList = Arrays.asList (new Object[] { createWaitMarker() });
        }
        return tempList;
    }

    TreeModelSupport getTree() {
        return tree;
    }
    
    TreeModelSupport getRootTree() {
        TreeModelSupport tree = getTree();
        if (tree != null) {
            return tree.getRootTree();
        } else if (this instanceof TreeModelSupport) {
            return (TreeModelSupport) this;
        } else {
            return null;
        }
    }
    
    int fullSize() {
        return getSize();
    }
    
    private TreePath path = null;
    void setPath (TreePath path) {
        this.path = path;
    }
    
    TreePath getPath() {
        return this.path;
    }
    
    static TreePath combine (TreePath a, TreePath b) {
        if (a == null || a.getPathComponent(0) == b.getPathComponent(0)) {
            return b;
        }
        List al = new ArrayList(a.getPathCount() + b.getPathCount());
        al.addAll (Arrays.asList(a.getPath()));
        al.addAll (Arrays.asList(b.getPath()));
        return new TreePath (al.toArray());
    }

    /**
     * Get a unique object for inclusion in a list or tree model, which
     * indicates an invalid object.  This is used for cases where a model
     * has an object which, if queried will throw exceptions because it
     * has become invalid, but the model has not yet been updated to remove
     * it.  Since tree models may not contain duplicate objects, this method
     * will return a new object each time, testable via <code>isInvalidMarker</code>.
     */
    public static final Object createInvalidMarker() {
        return new Unique(true);
    }
    
    /**
     * Get a unique object for inclusion in a list or tree model, which
     * indicates a model has not yet populated itself with data.  
     * Since tree models may not contain duplicate objects, this method
     * will return a new object each time, testable via <code>isWaitMarker</code>.
     */
    public static final Object createWaitMarker() {
        return new Unique(true);
    }
    
    public static final boolean isWaitMarker (Object o) {
        return o instanceof Unique && ((Unique) o).wait == true;
    }
    
    public static final boolean isInvalidMarker (Object o) {
        return o instanceof Unique && ((Unique) o).wait == false;
    }
    
    private static final class Unique {
        final boolean wait;
        Unique (boolean wait) {
            this.wait = wait;
        }
        public String toString() {
            return wait ? "wait" : "unique";
        }
    }
    
}
