/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * NavigatorListModel.java
 *
 * Created on September 11, 2004, 9:41 PM
 */

package org.netbeans.modules.java.navigation.spi;

import org.netbeans.modules.navigator.*;

import javax.swing.*;
import javax.swing.event.*;
import java.util.*;
import org.netbeans.modules.java.navigation.base.NavigatorModel;
import org.netbeans.modules.java.navigation.base.ModelBusyListener;


/**
 * A tree model which implements <code>DisplayProvider</code> to provide icons actions and importance-weighted text, and
 * implements <code>Filtered</code> to allow filtering of the contents of the tree model.
 * <p/>
 * Registered instances of ModelProvider create instances of NavigatorTreeModel to provide objects to display in the
 * Navigator view.
 * <p/>
 * <code>ListDataEvents</code> fired by this model must always be fired in the AWT Event Thread.
 * <p/>
 * Rather than implementing this class directly, consider using <code>ListModelSupport</code>.
 *
 * @author Tim Boudreau
 * @see ListModelSupport
 * @see DisplayProvider
 */
public interface NavigatorListModel extends ListModel, DisplayProvider, NavigatorModel {
    /**
     * Notifies the model that it has is in use and should, if necessary, listen for changes on the DataObject it
     * represents and propagate those as model changes.
     */
    public void addNotify ();

    /**
     * Notifies the model that it is no longer in use, and should dispose of any cached content and remove any listeners
     * to avoid memory leaks.
     */
    public void removeNotify ();

    /**
     * Get a list of objects in the model which match the passed string.
     *
     * @return A List of objects that are in this model
     */
    public List getSearchResults (String partial);

    public int indexOf (Object node);

    /**
     * Returns true if the model is loaded and functional.  Models which load data on a background thread should return
     * false from this property and fire a change event when they become loaded.
     */
    public boolean isReady ();

    /**
     * Add a change listener.  The following states are of interest - isReady, and if the model implements Reorderable,
     * isReorderable().
     * <p/>
     * Objects which will listen on the model should defer attaching listeners other than change listeners until the
     * model is ready.
     */
    public void addChangeListener (ChangeListener cl) throws TooManyListenersException;

    /**
     * Remove a change listener.  The following states are of interest - isReady, and if the model implements
     * Reorderable, isReorderable().
     */
    public void removeChangeListener (ChangeListener cl);
    
    /** Adds listener which informs clients when model is busy, means computing
     * come data etc. Max one listener is allowed.
     */
    public void addBusyListener (ModelBusyListener bl) throws TooManyListenersException;

    /** Removes busy listener.
     */
    public void removeBusyListener (ModelBusyListener bl);

    /** returns tooltip on given object on specific location */
    public String getTooltip (Object tooltipFor, int x, int y);
    
}
