/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * NavigatorTreeModel.java
 *
 * Created on September 11, 2004, 9:46 PM
 */

package org.netbeans.modules.java.navigation.spi;

import org.netbeans.modules.navigator.*;

import javax.swing.event.*;
import javax.swing.tree.*;
import java.util.*;
import org.netbeans.modules.java.navigation.base.NavigatorModel;

/**
 * A tree model which implements <code>DisplayProvider</code> to provide icons actions and importance-weighted text, and
 * implements <code>Filtered</code> to allow filtering of the contents of the tree model.
 * <p/>
 * Registered instances of ModelProvider create instances of NavigatorTreeModel to provide objects to display in the
 * Navigator view.
 * <p/>
 * TreeModelEvents from an instance of NavigatorTreeModel may only be fired on the AWT event dispatch thread.
 * <p/>
 * Rather than implementing this class directly, consider using <code>TreeModelSupport</code>.
 *
 * @author Tim Boudreau
 * @see TreeModelSupport
 * @see DisplayProvider
 */
public interface NavigatorTreeModel extends TreeModel, DisplayProvider, NavigatorModel {
    /**
     * Notifies the model that it has is in use and should, if necessary, listen for changes on the DataObject it
     * represents and propagate those as model changes.
     */
    public void addNotify ();

    /**
     * Notifies the model that it is no longer in use, and should dispose of any cached content and remove any listeners
     * to avoid memory leaks.
     */
    public void removeNotify ();

    /**
     * Notifies the model that a path is about to be expanded or collapsed. This hook can be used to discard data not
     * needed after a collapse, or to record expanded paths that should be reexpanded if the same object is displayed
     * again.
     */
    public void notifyExpandedState (TreePath path, boolean expanded);

    /**
     * Get an array of tree paths that should be expanded when the model is first displayed in a tree.  Views such as
     * structural views may want to automatically expand some elements by default.
     */
    public TreePath[] getDefaultExpandedPaths ();

    /**
     * Determine whether the root node of this model should be visible.
     */
    public boolean isShowRoot ();

    /**
     * Get a list of TreePaths to objects in the model which match the passed string.
     *
     * @return A List of TreePaths to matching objects that are in this model
     */
    public List getSearchResults (String partial);

    /**
     * Returns true if the model is loaded and functional.  Models which load data on a background thread should return
     * false from this property and fire a change event when they become loaded.
     * <p/>
     * Objects which will listen on the model should defer attaching listeners other than change listeners until the
     * model is ready.
     */
    public boolean isReady ();

    /**
     * Add a change listener.  The following states are of interest - isReady, and if the model implements Reorderable,
     * isReorderable().
     */
    public void addChangeListener (ChangeListener cl) throws TooManyListenersException;

    /**
     * Remove a change listener.  The following states are of interest - isReady, and if the model implements
     * Reorderable, isReorderable().
     */
    public void removeChangeListener (ChangeListener cl);
}
