/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * RelatedItemListModelSupport.java
 *
 * Created on September 23, 2004, 11:25 PM
 */

package org.netbeans.modules.java.navigation.spi;

import java.util.*;

/**
 * A convenience extension of ListModelSupport which implements RelatedItemProvider, and allows an instance of
 * RelatedItemProviderSupport to be provided and delegated to.
 *
 * @author Tim Boudreau
 * @see RelatedItemProvider
 */
public abstract class RelatedItemListModelSupport extends ListModelSupport implements RelatedItemProvider {
    private final RelatedItemProviderSupport provider;

    /**
     * Creates a new instance of RelatedItemListModelSupport which delegates to the passed RelatedItemProviderSupport,
     * and uses asynchronous read and updates.
     *
     * @param delegate A RelatedItemProviderSupport to delegate to
     * @param singleClick True if this model should return true from <code>isDefaultActionInstant()</code>.
     * @see NavigatorListModel#isDefaultActionInstant
     * @see RelatedItemProviderSupport
     * @see RelatedItemProvider
     */
    protected RelatedItemListModelSupport (RelatedItemProviderSupport delegate, boolean singleClick) {
        this ( delegate, singleClick, true, true );
    }

    protected RelatedItemListModelSupport (RelatedItemProviderSupport delegate,
                                           boolean singleClick, boolean readAsync, boolean updateAsync) {

        super ( singleClick, readAsync, updateAsync );
        this.provider = delegate;
        //Can imagine a subclass impl which might *not* want to support this, even
        //though the parent class does
        if ( delegate != null ) {
            delegate.setEventDelegate ( this );
        }
    }

    final boolean hasRelatedItemProvider () {
        return provider != null;
    }
    
    public final RelatedItemProviderSupport getRelatedItemProviderSupport () {
        return provider;
    }

    /**
     * Implementation of RelatedItemProvider.  To use, override <code>createRelatedItemProvider().
     *
     * @see RelatedItemProvider#removeRelatedItemListener
     */
    public final void removeRelatedItemListener (RelatedItemListener l) {
        if ( hasRelatedItemProvider () ) {
            provider.removeRelatedItemListener ( l );
        }
    }

    /**
     * Implementation of RelatedItemProvider.  To use, override <code>createRelatedItemProvider().
     *
     * @see RelatedItemProvider#isRelated
     */
    public final boolean isRelated (Object o) {
        if ( hasRelatedItemProvider () ) {
            return provider.isRelated ( o );
        } else {
            return false;
        }
    }

    /**
     * Implementation of RelatedItemProvider.  To use, override <code>createRelatedItemProvider().
     *
     * @see RelatedItemProvider#isPrimary
     */
    public final boolean isPrimary (Object o) {
        if ( hasRelatedItemProvider () ) {
            return provider.isPrimary ( o );
        } else {
            return false;
        }
    }

    public final Object getPrimaryItem () {
        if ( hasRelatedItemProvider () ) {
            return provider.getPrimaryItem ();
        } else {
            return null;
        }
    }

    /**
     * Implementation of RelatedItemProvider.  To use, override <code>createRelatedItemProvider().
     *
     * @see RelatedItemProvider#addRelatedItemListener
     */
    public final void addRelatedItemListener (RelatedItemListener l)
            throws TooManyListenersException {

        if ( hasRelatedItemProvider () ) {
            provider.addRelatedItemListener ( l );
        }
    }
    
    public void reset() {
        if (hasRelatedItemProvider()) {
            provider.reset();
        }
    }

    // << RelatedItemProvider implementation

}
