/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 *  You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 *  The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 *  Microsystems, Inc. All Rights Reserved.
 *
 */
/*
 * Reorderable.java
 *
 * Created on September 24, 2004, 3:20 PM
 */

package org.netbeans.modules.java.navigation.spi;

/**
 * Interface indicating a model supports the reordering of its elements, such that the user can drag elements from one
 * position to another or otherwise move them.  Poor man's drag and drop support, but covers most reasonable things
 * (should one really be able to drag a foreign class and drop it into another one anyway?  The full power of drag and
 * drop would, for Navigator's purposes, mainly be a great way to make a mess).
 *
 * @author Tim Boudreau
 */
public interface Reorderable {
    /**
     * Some models may support reordering only if a particular sort order is used (for example, if you're sorting
     * alphabetically, you're not showing a natural order anyway).  This method should return false if reordering is not
     * supported in the current sort mode.
     */
    boolean isReorderable ();

    /**
     * Move an object to a new location.  Returns null if the move succeeds; if it fails, a localized message explaining
     * what went wrong should be returned.
     */
    String move (Object o, int newLocation);
}
