/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * WeightedStringPainter.java
 *
 * Created on September 20, 2004, 1:10 PM
 */

package org.netbeans.modules.java.navigation.spi.strings;

import java.awt.*;

/**
 * An interface for things that can paint a WeightedString into a graphics context, eliding less important segments or
 * characters and handling markup. The default implementation makes a best-effort attempt to ensure the string fits, but
 * does not guarantee it.
 *
 * @author Tim Boudreau
 * @see WeightedString
 */
public interface WeightedStringPainter {
    /**
     * Paint the string, possibly eliding or omitting less important sections. The graphics context's current font will
     * be used as the base font to render with.
     *
     * @param g a graphics context
     * @param x horizontal coordinate at which to start painting
     * @param y vertical coordinate including the font baseline
     * @param ws a WeightedString to paint
     * @param maxChars a target maximum number of characters - the painter should try to trim the string based on
     * segment and character importance
     * @param useColorMarkup - if a selection background color is set, using colored markup can make the text invisible;
     * this will turn off coloring of text but keep styles such as bold and italic
     */
    public void paint (Graphics g, int x, int y, WeightedString ws, int maxChars, boolean useColorMarkup);
}
