/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * Entry.java
 *
 * Created on September 20, 2004, 12:07 PM
 */

package org.netbeans.modules.java.navigation.strings;

import org.netbeans.modules.java.navigation.spi.strings.Abbreviator;

/**
 * Sortable entry in a weighted string.
 *
 * @author Tim Boudreau
 */

final class Entry implements Comparable {
    private final char[] c;
    private final float importance;
    final int index;

    Entry (char[] c, float i, int index) {
        this.c = c;
        this.importance = i;
        this.index = index;
    }

    public int getIndex () {
        return index;
    }

    public int fullLength () {
        return c.length;
    }

    public int length () {
        return target == 0.0f ? c.length : getLengths ()[ (int) ( target * 10 ) ];
    }

    public int compareTo (Object o) {
        return (int) ( ( importance * 10000f ) - ( ( (Entry) o ).importance * 10000f ) );
    }

    public float getImportance () {
        return importance;
    }

    private float target = 0.0f;

    public void setTargetWeight (float target) {
        this.target = target;
    }

    private final Abbreviator abbrev = Abbreviator.getInstance ();

    public int[] getLengths () {
        abbrev.process ( c, target );
        return abbrev.getLengthsForLastRun ();
    }

    public int getLengthAtTarget () {
        int length = c.length;
        float[] weights = abbrev.process ( c, importance );
        for ( int i = c.length - 1; i >= 0; i-- ) {
            if ( weights[ i ] <= target ) {
                length--;
            }
        }
        return length;
    }

    private float[] getWeights () {
        float[] result = abbrev.process ( c, importance );

        StringBuffer sb = new StringBuffer ();
        for ( int i = 0; i < c.length; i++ ) {
            sb.append ( c[ i ] );
            sb.append ( ':' );
            sb.append ( result[ i ] );
            if ( i != result.length - 1 ) {
                sb.append ( ',' );
            }
        }

//        System.out.println("Weight " + new String(c) + " to " + sb);
        return result;
    }

    public void setSkip (boolean val) {
        this.skip = val;
    }

    private boolean skip = false;

    public boolean isSkip () {
        return skip;
    }

    public char[] elide (int wanted) {
        char[] copy = new char[c.length];
        
        // just return copy for one char c
        if (c.length == 1) {
            copy[0] = c[0];
            return copy;
        }
         
        System.arraycopy(c, 0, copy, 0, c.length);
        
        // mark eliminated letters as 0 value 
        float[] weights = getWeights ();
        int length = copy.length;
        for ( int i = copy.length - 1; i >= 0; i-- ) {
            if ( length <= wanted ) {
                break;
            }
            if ( weights[ i ] <= target ) {
                copy[i] = 0;
                length--;
            }
        }

        if (length == c.length ) {
            // no abbreviation happened
            return copy;
        }
        
        // create result - value of copy without 0s
        char[] result = new char[length];
        int ix = 0;
        for (int i = 0; i < copy.length; i++) {
            if (copy[i] != 0) {
                result[ix] = copy[i];
                ix++;
            }
        }

        return result;
    }

    public String toString () {
        if ( skip ) {
            //return "";
        }
        if ( target == 0.0f ) {
            return new String ( c );
        }
        StringBuffer sb = new StringBuffer ();
        for ( int i = 0; i < c.length; i++ ) {
            if ( c[ i ] != 0 ) {
                sb.append ( c[ i ] );
            }
        }
        return sb.toString ();
    }
}

