/*
 * ClassMemberModelTest.java
 * JUnit based test
 *
 * Created on January 28, 2005, 2:29 PM
 */

package org.netbeans.modules.java.navigation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.diff.Diff;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.navigation.ClassMemberModel;
import org.netbeans.modules.javacore.api.JavaModel;
//import org.netbeans.modules.navigator.FiltersDescription;
//import org.netbeans.modules.navigator.FiltersManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject; 
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.netbeans.jmi.javamodel.*;
/**
 *
 * @author pzajac
 */
public class ClassMemberModelTest extends NbTestCase { 
    public static final int MEMBER_MODEL = 0;
    public static final int INHERIT_MODEL = 1;
    FileObject fo;
    File outDir;
    StringBuffer logBuf;
    
    public ClassMemberModelTest(String testName) {
        super(testName);
    }
    
    public void testSimpleMembersClasses() throws Exception {
    
       logBuf = new StringBuffer(); 
       SimpleClassMemberGenerator generator = new SimpleClassMemberGenerator(System.getProperty("java.specification.version") + "_smembers.ref");
       
       generator.proccessFos(fo,outDir);
       assertTrue(logBuf.toString(), logBuf.length() == 0);
    }
    
    public void testInheritance() throws Exception {
       logBuf = new StringBuffer(); 
       InheritenceGenerator generator = new InheritenceGenerator(System.getProperty("java.specification.version") + "_inherit.ref");
       
       generator.proccessFos(fo,outDir);
       assertTrue(logBuf.toString(), logBuf.length() == 0);
        
    }
    
    abstract class GoldenFilesGenerator {
        String extension;
        public GoldenFilesGenerator (String extension) {
            this.extension = extension;
        } 
        /** process recursively files
         */
        public final void proccessFos(FileObject fo,File outDir) throws Exception {
            if (fo.isFolder()) {
                outDir = new File(outDir,fo.getName());
                outDir.mkdirs();
                FileObject fos [] = fo.getChildren();
                for (int fIt = 0 ; fIt < fos.length ; fIt++ ) { 
                    proccessFos(fos[fIt],outDir); 
                }            
            } else if (fo.getExt().equals("java")) {
                  JavaDataObject dobj = (JavaDataObject) DataObject.find(fo); 
                  log(fo.getPath());
                  File parent = FileUtil.toFile(fo.getParent());
                  File refFile = new File(parent,fo.getName() + extension );
                  File newRefFile = new File(outDir, fo.getName() + extension);
                  FileOutputStream fos = new FileOutputStream(newRefFile );  
                  PrintStream ps2 = new PrintStream(fos);


                  // tests member model
                  //
                  proccessSingleFileObject(dobj,ps2); 
    
                  ps2.close();
                  if (refFile.exists()) {
                      InputStream is1 = new FileInputStream(refFile); 
                      InputStream is2 = new FileInputStream(newRefFile); 
                      if (!compareFiles(is1,is2)) {  
                          logBuf.append(fo.getPath());
                          logBuf.append(" is different\n");
                      }
                      is1.close();
                      is2.close();
                  } else {
                          logBuf.append(fo.getPath());
                          logBuf.append(" has not ref file\n"); 
                  }
                  Diff diff = null;
            }
       }
        
        protected abstract void proccessSingleFileObject(JavaDataObject dobj,PrintStream refstream) ;
        
    } // end of GoldenFilesGenerator

    /** genrator for members view
     */
    private class SimpleClassMemberGenerator extends GoldenFilesGenerator {
        SimpleClassMemberGenerator(String extension) {
            super(extension);
        }
        protected void proccessSingleFileObject(JavaDataObject dobj,PrintStream refstream) {
               Resource res = JavaModel.getResource(dobj.getPrimaryFile());
               JavaClass javaclass  = findClassMember(res); 
               ClassMemberModel cmm = new ClassMemberModel(javaclass);
                      List list = cmm.loadContents();
//                      ArrayList content = new ArrayList();
                      for (Iterator it = list.iterator() ; it.hasNext();) {
                        ClassMemberModel.ItemPaintingData data = (ClassMemberModel.ItemPaintingData)it.next();
                        refstream.println(data.getWString().toString());
                      }
        } 
    }
    
    /** generator for inheritance view
     */
    private class InheritenceGenerator extends GoldenFilesGenerator { 
        InheritenceGenerator (String extension) { 
            super(extension);  
        }
        protected void proccessSingleFileObject(JavaDataObject dobj,PrintStream refstream) {
           InheritanceTreeModel itm = new InheritanceTreeModel(dobj);
           List /*Classdefinition */contents = itm.testLoadContents(); 
           for (Iterator it = contents.iterator() ; it.hasNext() ;) {
               ClassDefinition cd = (ClassDefinition) it.next();
               refstream.println(cd.getName());
           }
       }
    }
     
    private static boolean compareFiles(InputStream is1,InputStream is2) {  
        InputStreamReader isr1 = new InputStreamReader(is1); 
        InputStreamReader isr2 = new InputStreamReader(is2); 
        
        BufferedReader br1 = new BufferedReader(isr1); 
        BufferedReader br2 = new BufferedReader(isr2); 
        
        String s1, s2;
        try {
            do {
                s1 = br1.readLine();
                s2 = br2.readLine();
                if (s1 == null && s2 == null) {
                    return true;
                }
                if (s1 == null || s2 == null) {
                    return false;
                }
                if (s1.equals(s2) == false) {
                    return false;
                }
            } while (true);
        } catch (IOException ioe) {
            return false;
        }
        finally {
            try {
                br1.close();
                br2.close();
                isr1.close();
                isr2.close();
            } catch (IOException e) {}
        }
        
    }
    
    // TODO add test methods here. The name must begin with 'test'. For example:
    // public void testHello() {}

    protected void setUp() throws Exception {
       fo = FileUtil.toFileObject(getDataDir()); 
        outDir = new File(getWorkDir(),"out");   
       logBuf = new StringBuffer();

    }
    
   public static JavaClass findClassMember(org.netbeans.jmi.javamodel.Resource resource) {
        List classifiers = resource.getClassifiers(); 
        JavaClass clazz = null; 
        for (Iterator it = classifiers.iterator() ; it.hasNext() ; ) { 
            Object obj = it.next(); 
            if (obj instanceof JavaClass) { 
                clazz = (JavaClass) obj; 
                break;
            }
        }
        return (JavaClass)clazz;
    }
}
