/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * BehavioralSymbolInfo.java
 *
 * Created on April 19, 2004, 2:14 PM
 */

package org.netbeans.lib.java.parser;

/** This class encapsulates semantic info about constructor and method
 * @author Tomas Hurka
 */
public class BehavioralSymbolInfo extends FeatureSymbolInfo {

    /** Holds array of FQN of parameter's types. */    
    public final String[] params;
    
    public BehavioralSymbolInfo(int type, String name,String owner,String[] pars) {
        super(type, name, owner);
        params=pars;
    }

    public String toString() {
	StringBuffer sb = new StringBuffer("[");
	for (int i = 0; i < params.length; i++) {
	    sb.append(params[i]);
	    if (i + 1 < params.length)
		sb.append(',');
	}
	sb.append("]");
	return super.toString() + ", params=" + sb.toString();
    }
}
