/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.java.parser;

/**
 * The class <code>CompilerException</code> is thrown when the compiler
 * aborts during parsing or error checking.  Its cause is the original
 * <code>Throwable</code>.  The detail messages of this exception and
 * its cause are identical.
 *
 * @author  Tom Ball
 */
public class CompilerException extends Exception {

    /**
     * Constructs a new compiler exception with the specified cause.
     * The message for this exception is copied from the cause throwable.
     *
     * @param cause the throwable to be wrapped by this exception.  It
     *        cannot be null.
     */
    public CompilerException(Throwable cause) {
	super(cause.getMessage(), cause);
    }

}
