/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.java.parser;

import java.io.Reader;

/**
 *
 */
public interface ECRequestDesc {
    String getBootClassPath();
    String getSourceClassPath();
    String getClassPath();
    String getSourceLevel();
    ErrConsumer getErrConsumer();
    Reader getReader();
    String getFileName();

    /**
     * Get the text of a specified Java source file.  This method may
     * be called by the error checker to retrieve source files for
     * classes referenced by the main class being checked.
     */
    Reader getReader(String filename);
    /**
     * Returns true if a given file is modified in the editor.
     */
    boolean isModified(String filename);
}
