/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.lib.java.parser;


/**
 * This interface provides information about error/warings generaated by compiler
 */
public interface ErrConsumer {

    /** Represents a error message with severity "error" (e.g. makes
     * compilation fail. 
     */
    final public static Object ERROR = 
        new String("Error"); // new: don't intern. Just needs to be a unique
                        // object, but String has a nice toString() behavior

    /** Represents a message with severity "warning" (e.g.
     * compilation can proceed)
     */
    final public static Object WARNING = new String("Warning");

    /**
     * Forwards one error/waring from the compiler
     * @param key unique identification of this error
     * @param args Fields of the error message
     * @param severity the severity of the error; it's either ERROR or WARNING
     * @param errorFileName name of the source file where error occured
     * @param line the line number on which the error occurred
     * @param column the column number within the line on which the error occurred
     * @param message he text description of the error
     */    
    public void pushError (Object severity,
                           String errorFileName,
                           int line,
                           int column,
                           String message,
                           String key,
                           String[] args);
}
