/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.lib.java.parser;

import org.openide.ErrorManager;
import org.openide.modules.InstalledFileLocator;
import java.lang.reflect.*;
import java.io.Reader;
import java.io.File;
import java.net.URLClassLoader;
import java.net.URL;
import java.security.*;

/**
 * Generates Parser and Scanner instances.
 */
public final class Factory {
    private static Factory instance = null;
    private static Constructor newParser;
    private static Method newScanner;
    private static Constructor newErrorChecker;
    
    public static synchronized Factory getDefault() {
        if (instance == null) {
            instance = new Factory();

            Class[] newParserTypes = new Class[] {
                ASTContext.class, Reader.class, String.class
            };

            Class[] newScannerTypes = new Class[] {
                Reader.class, String.class, Boolean.TYPE
            };

            Class[] newCheckerTypes = new Class[] {
                ECRequestDesc.class
            };

            File gjastJar = InstalledFileLocator.getDefault().locate("modules/ext/gjast.jar", "org.netbeans.modules.javacore", false);

            if (gjastJar != null) {
                //ErrorManager.getDefault().log(ErrorManager.USER, "javac bridge found in: " + gjastJar.getAbsolutePath());
                try {
                    ClassLoader loader = new GJASTClassLoader(gjastJar.toURI().toURL());
                    Class c = Class.forName("org.netbeans.lib.gjast.ASParser", true, loader);
                    newParser = c.getConstructor(newParserTypes);
                    c = Class.forName("org.netbeans.lib.gjast.ASScanner$Factory", true, loader);
                    newScanner = c.getMethod("newScanner", newScannerTypes);
                    c = Class.forName("org.netbeans.lib.gjast.ASErrorChecker", true, loader);
                    newErrorChecker = c.getConstructor(newCheckerTypes);
                    //ErrorManager.getDefault().log(ErrorManager.USER, "loaded javac bridge");
                } catch (Exception e) {
                    throw new RuntimeException("Cannot load javac bridge classes: " + e);
                }
            } else {
                ErrorManager.getDefault().log(ErrorManager.USER, "javac bridge not present");
                try {
                    newParser = Parser.class.getConstructor(newParserTypes);
                    newScanner = Scanner.class.getMethod("newScanner", newScannerTypes);
                    newErrorChecker = Factory.DummyErrorChecker.class.getConstructor(newCheckerTypes);
                } catch (Exception e) {
                    throw new RuntimeException("Cannot load parser classes: " + e);
                }
            }
        }
        return instance;
    }

    public JParser getParser(ASTContext context, Reader in, String filename) {
	try {
	    return (JParser)newParser.newInstance(new Object[] { 
		context, in, filename 
	    });
	} catch (Exception e) {
	    throw new RuntimeException("Cannot create parser: " + e);
	}
    }

    public JScanner getScanner(Reader in,String sourceLevel) {
	return getScanner(in, sourceLevel, false);
    }

    public JScanner getScanner(Reader in,String sourceLevel, 
			       boolean liteScanning) {
	try {
	    return (JScanner)newScanner.invoke(null, new Object[] { 
		in, sourceLevel, Boolean.valueOf (liteScanning)
	    });
	} catch (Exception e) {
	    Throwable t = e.getCause();
	    System.err.println("Factory: cannot create scanner " + 
			       (t != null ? t : e));
	    throw new RuntimeException("Cannot create scanner: " +
				       t != null ? t : e);
	}
    }

    public ErrorChecker getErrorChecker(ECRequestDesc desc) {
        try {
            return (ErrorChecker) newErrorChecker.newInstance(new Object[] { desc });
	} catch (Exception e) {
	    Throwable t = e.getCause();
	    throw new RuntimeException("Cannot create errorChecker: " +
                                       t != null ? t : e);
	}
    }

    private static class GJASTClassLoader extends URLClassLoader {
        private final PermissionCollection permissions = new Permissions();

        public GJASTClassLoader(URL gjastJar) {
            super(new URL[] {gjastJar}, Factory.class.getClassLoader());
            permissions.add(new AllPermission());
        }

        protected Class loadClass(String n, boolean r) throws ClassNotFoundException {
            if (n.startsWith("com.sun.tools.javac") || n.startsWith("org.netbeans.lib.gjast")) { // NOI18N
                // Do not proxy to parent!
                Class c = findLoadedClass(n);
                if (c != null) return c;
                c = findClass(n);
                if (r) resolveClass(c);
                return c;
            } else {
                return super.loadClass(n, r);
            }
        }

        protected PermissionCollection getPermissions(CodeSource codesource) {
            return permissions;
        }
    }
    
    private static class DummyErrorChecker implements ErrorChecker {
        
        public DummyErrorChecker(ECRequestDesc desc) {
        }

        public int parse() throws CompilerException {
            return 0;
        }
        
    }
}
