/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * FeatureSymbolInfo.java
 *
 * Created on April 19, 2004, 2:13 PM
 */

package org.netbeans.lib.java.parser;

/** This class encapsulates semantic info about Package,
 * Java Class and Field
 * @author Tomas Hurka
 */
public class FeatureSymbolInfo extends SymbolInfo {
    
    /** FQN name of package or java class or simple name of the field or method. Null for constructor*/    
    public final String name;

    /** FQN of the owner of this symbol. Owner of top-level java class is package, owner
     * of field or method is its declaring class, owner of inner class is its declaring class.
     */    
    public final String owner;
    
    public FeatureSymbolInfo(int type, String n,String o) {
        super(type);
        name=n;
        owner=o;
    }
    
    public String toString() {
	return super.toString() + ", name=" + name + ", owner=" + owner;
    }
}
