/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.java.parser;

/**
 * Java scanner interface
 */
public interface JScanner {
    /**
     * Returns the text of the current lexical token.
     */
    String yytext();

    /**
     * Returns the next lexical token.
     *
     * @see org.netbeans.lib.java.parser.ParserTokens
     */
    int yylex() throws java.io.IOException;

    /**
     * Returns the hash code of the current lexical token's text.
     * This value should be identical to that returned from
     * <code>"yytext().hashCode();"</code>
     */
    int yyhash();

    /**
     * Returns the current state of the scanner's deprecatedFlag
     * property.  This property is set true when a deprecated tag
     * is found in a doc-comment.  This needs to be reset by the
     * client with resetDeprecatedFlag.
     */
    boolean isDeprecated();

    /**
     * Reset the scanner's deprecated flag state.
     */
    void resetDeprecatedFlag();
}
