/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * Token.java
 *
 * Created on January 7, 2002, 3:06 PM
 */

package org.netbeans.lib.java.parser;

/**
 *
 * @author  Tomas Hurka
 */
public final class ScannerToken extends ASTClass implements Token {
    
    private Token padding[];
    private int tokenIndex;
    private Object value;
    private int startCharOffset;
    private int endCharOffset;
    private boolean deprecatedFlag;  // deprecated flag setting
    
    public ScannerToken(int t, int start, int end, Token[] pad, int index) {
        super(null,t);
        startCharOffset=start;
        endCharOffset=end;
        padding=pad;
        tokenIndex=index;
    }
    
    public ScannerToken(int t, Object o, int start, int end, Token[] pad, int index) {
        this(t,start,end,pad,index);
        value=o;
    }
    
    public ScannerToken(int t, Object o, int start, int end, Token[] pad, int index, boolean deprecated) {
        this(t,o,start,end,pad,index);
        deprecatedFlag = deprecated;
    }
    
    public ScannerToken(int t, Object o, int start, int end, Token[] pad, int index, boolean deprecated, ASTContext context) {
        this(t,o,start,end,pad,index, deprecated);
	setContext(context);
    }
    
    int getTokenIndex() {
        return tokenIndex;
    }
    
    void setContext(ASTContext context) {
        astContext = context;
    }
    
    public String toString() {
        String s="Type "+getType();
        
        if (value==null)
            return s;
        return s+" :"+value;
    }
    
    public int getStartOffset() {
        return startCharOffset;
    }
    
    public int getEndOffset() {
        return endCharOffset;
    }
    
    /** Getter for property padding.
     * @return Value of property padding.
     */
    public Token[] getPadding() {
        return padding;
    }
    
    /** Getter for property value.
     * @return Value of property value.
     */
    public Object getValue() {
        return value;
    }
    /* methods from ASTree */
       
    public int getFirstToken() {
        return tokenIndex;
    }
    
    public int getLastToken() {
        return tokenIndex;
    }
    
    public ASTree[] getSubTrees() {
        return null;
    }  

    /**
     * Returns the scanner's deprecatedFlag setting when this token
     * was created.  Note:  this does not indicate whether the structure
     * associated with this token is actually deprecated, only the
     * scanner's state.  This is necessary so that accurate deprecation
     * information can be returned after the scanner instance is released
     * from a token array.
     */
    public boolean getDeprecatedFlag() {
	return deprecatedFlag;
    }
}
