/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * SymbolInfo.java
 *
 * Created on April 19, 2004, 2:05 PM
 */

package org.netbeans.lib.java.parser;

/** This class is common ancesor for classes encapsulaion semantic information about
 * Java elements. It defines constants for Java elements it can contain.
 * @author Tomas Hurka
 */
public abstract class SymbolInfo {
    
    public static final int PACKAGE=0;
    public static final int JAVACLASS=1;
    public static final int FIELD=2;
    public static final int METHOD=3;
    public static final int CONSTRUCTOR=4;
    public static final int PARAMETER=5;
    public static final int LOCVAR=6;
    public static final int TYPEPARAMETER=7;

    /** holds type of Java element. It is one of PACKAGE, JAVACLASS,
     * FIELD, METHOD, CONSTRUCTOR, PARAMETER, LOCVAR or TYPEPARAMETER
     */    
    public final int type;
    
    public SymbolInfo(int t) {
        type=t;
    }

    public String toString() {
        String cls = this.getClass().getName();
        int i = cls.lastIndexOf('.');
        if (i > -1)
        cls = cls.substring(i+1);
        switch (type) {
            case PACKAGE: return cls + ":PACKAGE";
            case JAVACLASS: return cls + ":JAVACLASS";
            case FIELD: return cls + ":FIELD";
            case METHOD: return cls + ":METHOD";
            case CONSTRUCTOR: return cls + ":CONSTRUCTOR";
            case PARAMETER: return cls + ":PARAMETER";
            case LOCVAR: return cls + ":LOCVAR";
            case TYPEPARAMETER: return cls + ":TYPEPARAMETER";
            default:
                return cls + ":<unknown type>";
        }
    }
}
