
%{
    import java.io.*;
%}


/* keywords */
%token ABSTRACT,ASSERT,BOOLEAN,BREAK,BYTE,CASE,CATCH,CHAR,CLASS,CONST,CONTINUE
%token DEFAULT,DO,DOUBLE,ELSE,EXTENDS,FINAL,FINALLY,FLOAT,FOR,GOTO,IF,IMPLEMENTS
%token IMPORT,INSTANCEOF,INT,INTERFACE,LONG,NATIVE,NEW,PACKAGE,PRIVATE,PROTECTED
%token PUBLIC,RETURN,SHORT,STATIC,STRICTFP,SUPER,SWITCH,SYNCHRONIZED,THIS,THROW
%token THROWS,TRANSIENT,TRY,VOID,VOLATILE,WHILE

/* separators */
%token L_PAR,R_PAR,L_CURLY,R_CURLY,L_BRACKET,R_BRACKET,SEMICOLON,COMMA,DOT

/* operators */
%token ASSIGN,GT,LT,NOT,COMP,QUESTION,COLON,EQ,LTE,GTE,NEQ,BOOL_AND,BOOL_OR
%token INCREMENT,DECREMENT,PLUS,MINUS,MULTI,DIV,AND,OR,XOR,MOD,L_SHIFT
%token R_SHIFT,UR_SHIFT,PLUS_ASSIGN,MINUS_ASSIGN,MULTI_ASSIGN,DIV_ASSIGN
%token AND_ASSIGN,OR_ASSIGN,XOR_ASSIGN,MOD_ASSIGN,L_SHIFT_ASSIGN,R_SHIFT_ASSIGN
%token UR_SHIFT_ASSIGN

/* literals */
%token BOOL_LIT,INT_LIT,FLOAT_LIT,CHAR_LIT,STRING_LIT,NULL_LIT

/* identifier */
%token IDENTIFIER

/* padding tokens */
%token COMMENT,EOL_COMMENT,DOC_COMMENT,WHITESPACE,EOL

%start compilation_unit

%%
/* 4.1 */
type: primitive_type
    | reference_type 
    ;

/* 4.2 */
primitive_type: numeric_type
    | BOOLEAN
    | VOID /* only for methods */
    ;

numeric_type: integer_type
    | floating_point_type
    ;

integer_type: BYTE
    | SHORT
    | INT
    | LONG
    | CHAR
    ;

floating_point_type: FLOAT
    | DOUBLE
    ;

/* 4.3 */
reference_type: multi_part_id
    | multi_part_id dims
    | primitive_type dims
/* GJ 2.1 */
	| multi_part_id type_arguments
    ;

/* GJ 2.1 */
type_arguments_opt : /* empty */
	| type_arguments
	;
	
type_arguments: LT reference_type_list GT
	;
	
reference_type_list: reference_type
    | reference_type_list COMMA reference_type
	;
	
/* 7.3 */
compilation_unit: package_declaration import_declarations type_declarations
    ;

import_declarations: /* empty */
    | import_declarations import_declaration
    ;

type_declarations: /* empty */
    | type_declarations type_declaration
    ;

/* 7.4.1 */
package_declaration: /* empty */
	| PACKAGE multi_part_id SEMICOLON
    ;

/* 7.5 */
import_declaration: single_type_import_declaration 
    | type_import_on_demand_declaration
    ;

/* 7.5.1 */
single_type_import_declaration: IMPORT multi_part_id SEMICOLON
    ;

/* 7.5.2 */
type_import_on_demand_declaration: IMPORT multi_part_id DOT MULTI SEMICOLON
    ;

/* 7.6 */
type_declaration : class_declaration
    | interface_declaration
    | SEMICOLON
    ;

/* 8.1 */ 
/* class_declaration: modifiers CLASS IDENTIFIER super interfaces class_body
    | CLASS IDENTIFIER super interfaces class_body
    ;
*/
/* GJ 2.2 */
class_declaration: modifiers CLASS IDENTIFIER type_parameters_opt super interfaces class_body
    | CLASS IDENTIFIER type_parameters_opt super interfaces class_body
    ;
type_parameters_opt: /* empty */
	| type_parameters
	;
	
type_parameters: LT type_parameter_list GT
	;
	
type_parameter_list: type_parameter
	| type_parameter_list COMMA type_parameter
	;
	
type_parameter: IDENTIFIER type_bounds
	;

type_bounds: /* empty */
	| EXTENDS multi_part_id additional_bound_list
	;

additional_bound_list: /* empty */
	| additional_bound_list AND multi_part_id
	;

/* 8.1.1 */
/* removed 
    class_modifiers: *//* empty */
/*    | class_modifiers class_modifier
    ;

class_modifier: PUBLIC
    | PROTECTED
    | PRIVATE
    | ABSTRACT
    | STATIC
    | FINAL
    | STRICTFP
    ;
*/

/* 8.1.3 */
super : /* empty */
    | EXTENDS multi_part_id
    ;

/* 8.1.4 */
interfaces: /* empty */
    | IMPLEMENTS id_type_list
    ;

id_type_list: multi_part_id
    | id_type_list COMMA multi_part_id
    ;

/* 8.1.5 */
class_body: L_CURLY class_body_declarations R_CURLY
    ;

class_body_declarations: /* empty */
    | class_body_declarations class_body_declaration
    ;

class_body_declaration: class_member_declaration 
    | instance_initializer 
    | static_initializer
    | constructor_declaration
    ;

class_member_declaration: field_declaration
    | method_declaration
    | class_declaration
    | interface_declaration
    | SEMICOLON
    ;

/* 8.3 */
field_declaration: modifiers type variable_declarators SEMICOLON
    | type variable_declarators SEMICOLON
    ;

variable_declarators: variable_declarator
    | variable_declarators COMMA variable_declarator
    ;

variable_declarator: variable_declarator_id variable_initializer_opt
    ;

variable_declarator_id: IDENTIFIER
    | IDENTIFIER dims
    ;

variable_initializer_opt: /* empty */
    | ASSIGN variable_initializer

variable_initializer: expression
    | array_initializer
    ;

/* 8.3.1 */
/* removed 
field_modifiers:
    | field_modifiers field_modifier
    ;

field_modifier: PUBLIC
    | PROTECTED
    | PRIVATE
    | STATIC
    | FINAL 
    | TRANSIENT
    | VOLATILE
    ;
*/

/* 8.4 */
method_declaration: method_header method_body
    ;
/*
method_header: modifiers type method_declarator throws
    | type method_declarator throws
    ;
*/
/* GJ 3.1 */
method_header: modifiers type_parameters type method_declarator throws
	| modifiers type method_declarator throws
    | type_parameters type method_declarator throws
    | type method_declarator throws
    ;

/*
result_type: type
    | VOID
    ;
*/

method_declarator: IDENTIFIER L_PAR formal_parameter_list_opt R_PAR
    ;


/* 8.4.1 */
formal_parameter_list_opt : /* empty */
    | formal_parameter_list 
    ;

formal_parameter_list: formal_parameter
    | formal_parameter_list COMMA formal_parameter
    ;

formal_parameter : final_opt type variable_declarator_id
    ;

final_opt: /* empty */
    | FINAL
    ;


/* 8.4.3 */
/* removed 
method_modifiers: *//* empty */
/*    | method_modifiers method_modifier
    ;

method_modifier: PUBLIC
    | PROTECTED
    | PRIVATE
    | ABSTRACT
    | STATIC
    | FINAL
    | SYNCHRONIZED
    | NATIVE
    | STRICTFP
    ;
*/

/* 8.4.4 */
throws: /* empty */
    | THROWS id_type_list
    ;

/* 8.4.5 */
method_body: block
    | SEMICOLON
    ;

/* 8.6 */
instance_initializer: block
    ;

/* 8.7 */
static_initializer: modifiers block
    ;

/* 8.8 */
constructor_declaration: modifiers constructor_declarator throws constructor_body
    | constructor_declarator throws constructor_body
    ;

constructor_declarator: IDENTIFIER L_PAR formal_parameter_list_opt R_PAR
    ;

/* 8.8.3 */
/* removed 
constructor_modifiers: *//* empty */
/*    | constructor_modifiers constructor_modifier
    ;

constructor_modifier: PUBLIC
    | PROTECTED
    | PRIVATE
    ;
*/

/* 8.8.5 */
/* constructor_body: L_CURLY explicit_constructor_invocation block_statements_opt R_CURLY */
constructor_body: L_CURLY constructor_block_statements R_CURLY
    ;

/* 8.8.5.1 */
constructor_block_statements: /* empty */
    | constructor_block_statements constructor_block_statement
    ;

constructor_block_statement: block_statement
    | THIS L_PAR argument_list_opt R_PAR SEMICOLON
    | SUPER L_PAR argument_list_opt R_PAR SEMICOLON
    | primary DOT SUPER L_PAR argument_list_opt R_PAR SEMICOLON
    | multi_part_id DOT SUPER L_PAR argument_list_opt R_PAR SEMICOLON
    ;

/*
explicit_constructor_invocation: 
    | THIS L_PAR argument_list_opt R_PAR SEMICOLON
    | SUPER L_PAR argument_list_opt R_PAR SEMICOLON
    | primary DOT SUPER L_PAR argument_list_opt R_PAR SEMICOLON
    ;
*/

/* 9.1 */
/*
interface_declaration: modifiers INTERFACE IDENTIFIER extends_interfaces interface_body
    | INTERFACE IDENTIFIER extends_interfaces interface_body
    ;
*/
/* GJ 2.2 */
interface_declaration: modifiers INTERFACE IDENTIFIER type_parameters_opt extends_interfaces interface_body
    | INTERFACE IDENTIFIER type_parameters_opt extends_interfaces interface_body
    ;

/* 9.1.1 */
/* removed */
/* interface_modifiers: *//* empty */
/*    | interface_modifiers interface_modifier
    ;

interface_modifier: PUBLIC 
    | PROTECTED 
    | PRIVATE
    | ABSTRACT
    | STATIC
    | STRICTFP
    ;
*/

/* 9.1.2 */
extends_interfaces: /* empty */
    | EXTENDS id_type_list
    ;

/* 9.1.3 */
interface_body: L_CURLY interface_member_declarations R_CURLY 

interface_member_declarations: /* empty */
    | interface_member_declarations interface_member_declaration
    ;

interface_member_declaration: field_declaration /* constant_declaration */
    | abstract_method_declaration
    | class_declaration
    | interface_declaration
    | SEMICOLON
    ;

/* 9.3 */
/*constant_declaration: modifiers type variable_declarators
    | type variable_declarators
    ;
*/
/* removed 
constant_modifiers: *//* empty */
/*    | constant_modifiers constant_modifier
    ;

constant_modifier: PUBLIC
    | STATIC
    | FINAL
    ;
*/

/* 9.4 */
abstract_method_declaration: modifiers type /* result_type */ method_declarator throws SEMICOLON
    | type /* result_type */ method_declarator throws SEMICOLON
    ;

/* removed
* abstract_method_modifiers: 
*    | abstract_method_modifiers abstract_method_modifier
*    ;
*
* abstract_method_modifier: PUBLIC 
*    | ABSTRACT
*    ;
*/


/* 10.6 */
array_initializer: L_CURLY variable_initializers_opt /* comma_opt  */ R_CURLY
    ;

variable_initializers_opt: /* empty */
    | variable_initializers
    | variable_initializers COMMA
    ;

variable_initializers: variable_initializer
    | variable_initializers COMMA variable_initializer
    ;

/* 14.2 */
block: L_CURLY block_statements_opt R_CURLY
    ;

block_statements_opt: /* empty */
    | block_statements
    ;

block_statements: block_statement
    | block_statements block_statement
    ;

block_statement: local_variable_declaration_statement
    | class_declaration
    | statement
    ;

/* 14.4 */
local_variable_declaration_statement: local_variable_declaration SEMICOLON
    ;

local_variable_declaration: FINAL type variable_declarators
    | type variable_declarators
    ;

/* 14.5 */
/* modified */
statement: labeled_statement
    | if_statement
    | while_statement
    | for_statement
    | block
    | empty_statement
    | expression_statement
    | switch_statement
    | do_statement
    | break_statement
    | continue_statement
    | return_statement
    | synchronized_statement
    | throw_statement
    | try_statement
    | assert_statement	
    ;


/* 14.6 */
empty_statement: SEMICOLON
    ;

/* 14.7 */
labeled_statement: IDENTIFIER COLON statement
    ;

/* 14.8 */
expression_statement: statement_expression SEMICOLON
    ;

statement_expression: assignment
    | pre_increment_expression
    | pre_decrement_expression
    | post_increment_expression
    | post_decrement_expression
    | method_invocation
    | class_instance_creation_expression
    ;


/* 14.9 */
if_statement: IF L_PAR expression R_PAR statement
    | IF L_PAR expression R_PAR statement ELSE statement
    ;

/* 14.10 */
switch_statement: SWITCH L_PAR expression R_PAR switch_block
    ;

switch_block: L_CURLY switch_block_statement_groups switch_labels_opt R_CURLY
    ;

switch_block_statement_groups: /* empty */
    | switch_block_statement_groups switch_block_statement_group
    ;

switch_block_statement_group: switch_labels block_statements
    ;

switch_labels_opt: /* empty */
    | switch_labels
    ;

switch_labels: switch_label
    | switch_labels switch_label
    ;

switch_label: CASE constant_expression COLON
    | DEFAULT COLON
    ;

/* 14.11 */
while_statement: WHILE L_PAR expression R_PAR statement
    ;

/* 14.12 */
do_statement: DO statement WHILE L_PAR expression R_PAR SEMICOLON

/* 14.13 */
for_statement: FOR L_PAR for_init SEMICOLON expression_opt SEMICOLON for_update R_PAR statement
    ;

for_init: /* empty */
    | statement_expression_list
    | local_variable_declaration
    ;

expression_opt: /* empty */
    | expression 
    ;

for_update: /* empty */
    | statement_expression_list
    ;

statement_expression_list: statement_expression
    | statement_expression_list COMMA statement_expression
    ;

/* 14.14 */
break_statement: BREAK identifier_opt SEMICOLON
    ;

identifier_opt: /* empty */
    | IDENTIFIER
    ;

/* 14.15 */
continue_statement: CONTINUE identifier_opt SEMICOLON
    ;


/* 14.16 */
return_statement: RETURN expression_opt SEMICOLON
    ;

/* 14.17 */
throw_statement: THROW expression SEMICOLON
    ;

/* 14.18 */
synchronized_statement:  SYNCHRONIZED L_PAR expression R_PAR block
    ;

/* 14.19 */
try_statement: TRY block catches
    | TRY block catches_opt finally
    ;

catches_opt: /* empty */
    | catches
    ;

catches: catch_clause
    | catches catch_clause
    ;

catch_clause: CATCH L_PAR formal_parameter R_PAR block
    ;

finally: FINALLY block
    ;

/* 14.xx */
assert_statement: ASSERT expression SEMICOLON
    | ASSERT expression COLON expression SEMICOLON
    ;

/* 15.8 */
primary: primary_no_new_array
    | array_creation_expression
    ;

primary_no_new_array: literal
/*   | type DOT CLASS */
/*   | VOID DOT CLASS */
    | multi_part_id DOT CLASS
    | multi_part_id dims DOT CLASS
    | primitive_type DOT CLASS
    | primitive_type dims DOT CLASS

    | THIS
    | multi_part_id DOT THIS
    | L_PAR expression R_PAR
    | class_instance_creation_expression
    | field_access
    | method_invocation
    | array_access
    ;

/* 15.8.1 */
literal: INT_LIT
    | FLOAT_LIT
    | BOOL_LIT
    | CHAR_LIT
    | STRING_LIT
    | NULL_LIT
    ;

/* 15.9 */
/* class_instance_creation_expression: NEW multi_part_id L_PAR argument_list_opt R_PAR class_body_opt
    | primary DOT NEW IDENTIFIER L_PAR argument_list_opt R_PAR class_body_opt
    | multi_part_id DOT NEW IDENTIFIER L_PAR argument_list_opt R_PAR class_body_opt
    ;
*/
/* GJ 5.1 */
class_instance_creation_expression: NEW multi_part_id type_arguments_opt L_PAR argument_list_opt R_PAR class_body_opt
    | primary DOT NEW IDENTIFIER type_arguments_opt L_PAR argument_list_opt R_PAR class_body_opt
    | multi_part_id DOT NEW IDENTIFIER L_PAR argument_list_opt R_PAR class_body_opt
    ;

argument_list_opt: /* empty */
    | argument_list
    ;

argument_list: expression
    | argument_list COMMA expression
    ;

class_body_opt: /* empty */
    | class_body
    ;

/* 15.10 */
array_creation_expression: NEW primitive_type dim_exprs dims
    | NEW primitive_type dim_exprs
    | NEW multi_part_id dim_exprs dims
    | NEW multi_part_id dim_exprs
    | NEW primitive_type dims array_initializer
    | NEW multi_part_id dims array_initializer
    ;

dim_exprs: dim_expr
    | dim_exprs dim_expr
    ;

dim_expr: L_BRACKET expression R_BRACKET
    ;

dims: L_BRACKET R_BRACKET
    | dims L_BRACKET R_BRACKET
    ;

/* 15.11 */
field_access:  primary DOT IDENTIFIER
    | SUPER DOT IDENTIFIER
    | multi_part_id DOT SUPER DOT IDENTIFIER
    ;

/* 15.12 */
method_invocation: multi_part_id L_PAR argument_list_opt R_PAR
    | primary DOT IDENTIFIER L_PAR argument_list_opt R_PAR
    | SUPER DOT IDENTIFIER L_PAR argument_list_opt R_PAR
    | multi_part_id DOT SUPER DOT IDENTIFIER L_PAR argument_list_opt R_PAR
    ;

/* 15.13 */
array_access: multi_part_id L_BRACKET expression R_BRACKET
    | primary_no_new_array L_BRACKET expression R_BRACKET
    ;

/* 15.14 */
postfix_expression: primary
    | multi_part_id
    | post_increment_expression
    | post_decrement_expression
    ;

/* 15.14.1 */
post_increment_expression: postfix_expression INCREMENT
    ;

/* 15.14.2 */
post_decrement_expression: postfix_expression DECREMENT
    ;

/* 15.15 */
unary_expression: pre_increment_expression
    | pre_decrement_expression
    | PLUS unary_expression
    | MINUS unary_expression
    | unary_expression_not_plus_minus
    ;

pre_increment_expression: INCREMENT unary_expression
    ;

pre_decrement_expression: DECREMENT unary_expression
    ;

unary_expression_not_plus_minus: postfix_expression
    | COMP unary_expression
    | NOT unary_expression
    | cast_expression
    ;

/* 15.16 */
cast_expression: L_PAR primitive_type dims R_PAR unary_expression
    | L_PAR primitive_type R_PAR unary_expression
    | L_PAR expression R_PAR unary_expression_not_plus_minus
    | L_PAR multi_part_id dims R_PAR unary_expression_not_plus_minus
    ;

/* 15.17 */
multicaptive_expression: unary_expression
    | multicaptive_expression MULTI unary_expression
    | multicaptive_expression DIV unary_expression
    | multicaptive_expression MOD unary_expression
    ;

/* 15.18 */
additive_expression: multicaptive_expression
    | additive_expression PLUS multicaptive_expression
    | additive_expression MINUS multicaptive_expression
    ;

/* 15.19 */
shift_expression: additive_expression 
    | shift_expression L_SHIFT additive_expression
    | shift_expression R_SHIFT additive_expression
    | shift_expression UR_SHIFT additive_expression
    ;

/* 15.20 */
relational_expression: shift_expression
    | shift_expression LT shift_expression
    | shift_expression GT shift_expression
    | shift_expression LTE shift_expression
    | shift_expression GTE shift_expression
    | shift_expression INSTANCEOF reference_type
/*  original JLS code is IMHO wrong
    | relational_expression LT shift_expression
    | relational_expression GT shift_expression
    | relational_expression LTE shift_expression
    | relational_expression GTE shift_expression
    | relational_expression INSTANCEOF reference_type
*/
    ;

/* 15.21 */
equality_expression: relational_expression
    | equality_expression EQ relational_expression
    | equality_expression NEQ relational_expression
    ;

/* 15.22 */
and_expression: equality_expression
    | and_expression AND equality_expression
    ;

exclusive_or_expression: and_expression
    | exclusive_or_expression XOR and_expression
    ;

inclusive_or_expression: exclusive_or_expression
    | inclusive_or_expression OR exclusive_or_expression
    ;

/* 15.23 */
conditional_and_expression: inclusive_or_expression
    | conditional_and_expression BOOL_AND inclusive_or_expression
    ;

/* 15.24 */
conditional_or_expression: conditional_and_expression
    | conditional_or_expression BOOL_OR conditional_and_expression
    ;

/* 15.25 */
conditional_expression: conditional_or_expression
    | conditional_or_expression QUESTION expression COLON conditional_expression
    ;

/* 15.26 */
assignment_expression: conditional_expression
    | assignment
    ;

assignment: left_hand_side assignment_operator assignment_expression
    ;

left_hand_side: multi_part_id
    | field_access
    | array_access
    ;

assignment_operator: ASSIGN
    | PLUS_ASSIGN
    | MINUS_ASSIGN
    | MULTI_ASSIGN
    | DIV_ASSIGN
    | AND_ASSIGN
    | OR_ASSIGN
    | XOR_ASSIGN
    | MOD_ASSIGN
    | L_SHIFT_ASSIGN
    | R_SHIFT_ASSIGN   
    | UR_SHIFT_ASSIGN
    ;

/* 15.27 */
expression: assignment_expression
    ;

/* 15.28 */
constant_expression: expression
    ;



modifiers: modifier  
    | modifiers modifier
    ;

modifier: PUBLIC
    | PROTECTED
    | PRIVATE
    | ABSTRACT
    | STATIC
    | FINAL
    | SYNCHRONIZED
    | NATIVE
    | STRICTFP
    | TRANSIENT
    | VOLATILE
    ;

multi_part_id: IDENTIFIER
    | multi_part_id DOT IDENTIFIER 
    ;

%%

private Scanner scanner;

private int yylex() {
    try {
        return scanner.yylex();
    }
    catch (IOException e) {
        System.err.println("Error: "+e);
    }
    return -1;
}

private void yyerror(String s) {
    System.err.println("YYError: "+s);
}

public Parser(java.io.Reader in) {

    scanner = new Scanner(in);
    scanner.setParser(this);
}

public Parser(java.io.InputStream in) {
    scanner = new Scanner(in);
    scanner.setParser(this);
}

  public static void main(String argv[]) {
    if (argv.length == 0) {
      System.out.println("Usage : java Scanner <inputfile>");
    }
    else {
      for (int i = 0; i < argv.length; i++) {
        Parser parser = null;
        try {
          int status;

          System.out.println("File: "+argv[i]);
          parser = new Parser( new java.io.FileReader(argv[i]) );
          status=parser.yyparse();
          if (status!=0)
              System.exit(status);
        }
        catch (java.io.FileNotFoundException e) {
          System.out.println("File not found : \""+argv[i]+"\"");
        }
        catch (java.io.IOException e) {
         System.out.println("IO error scanning file \""+argv[i]+"\"");
          System.out.println(e);
        }
        catch (Exception e) {
          System.out.println("Unexpected exception:");
          e.printStackTrace();
        }
      }
    }
  }
