/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.lib.java.parser;

import java.io.*;
import java.util.ArrayList;

%%

// %debug 

%class UnicodeEscapes
%extends FilterReader
%type char[]
%switch
%16bit
%char
%final

HexDigit        = [0-9a-fA-F]

%state DIGITS

%init{
  super(in);
%init}

%{
    private char lastToken[]=null;

    private int escapeOffset = 0;
    private ArrayList escapes = new ArrayList(); 
    private int escapesIndex = -1;
    private int nextEscapePosition = -1;
    private int currentEscapeDispl = 0;

    private char value() {
        char r=0;
        String token = yytext();

        for (int k = token.length()-4; k < token.length(); k++) {
            int c = token.charAt(k);
            if (c >= 'a') 
                c-= 'a'-10;
            else if (c >= 'A')
                c-= 'A'-10;
            else
                c-= '0';
            r <<= 4;
            r += c;
	    }
        return r;
    }

    int convertPosition(int position) {
        if (escapes.isEmpty())
            return position;
        for (;;) {
            if (position <= nextEscapePosition)
                return position+currentEscapeDispl;
            if (nextEscapePosition != -1)
                currentEscapeDispl=((Integer)escapes.get(++escapesIndex)).intValue();
            if (escapes.size()<=escapesIndex+1) {
                nextEscapePosition = -1;
                return position+currentEscapeDispl;
            }
            nextEscapePosition=((Integer)escapes.get(++escapesIndex)).intValue();
        }        
    }

    public int read(char cbuf[], int off, int len) throws IOException {
        int tokenLen;

//        if ( !ready() ) return -1;
        if (lastToken==null) {    
            lastToken = yylex();
        }
        tokenLen = lastToken.length;
        if (tokenLen==0)
            return -1;
        if (len>=tokenLen) {
            System.arraycopy(lastToken,0,cbuf,off,tokenLen);
            lastToken=null;
            return tokenLen;
        }
        char token[]=new char[lastToken.length-len];
        System.arraycopy(lastToken,0,cbuf,off,len);
        System.arraycopy(lastToken,len,token,0,token.length);
        lastToken=token;
        return len;
    }

    public boolean markSupported() { 
        return false; 
    }

    public boolean ready() throws IOException {
        return lastToken!=null || (!yy_atEOF && (yy_currentPos < yy_endRead || yy_reader.ready()));
    }

%}

%%

<YYINITIAL> {
 \\ (\\\\)* u	{ yybegin(DIGITS); 
                  escapes.add(new Integer(yychar-escapeOffset));
                  escapeOffset+=yylength();
                }
 \\+		{ return yytext().toCharArray(); }
 ([^\\]|\n)+    { return yytext().toCharArray(); }

 <<EOF>>        { return new char[0]; }
}

<DIGITS> {
  u* {HexDigit} {4}  { yybegin(YYINITIAL);
                       escapeOffset+=yylength()-1;
                       escapes.add(new Integer(escapeOffset));
                       return new char[]{value()};
                     }
  .|\n             { throw new Error("incorrect Unicode escape"); }

  <<EOF>>          { throw new Error("EOF in Unicode escape"); }
}
