/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * TestFreeformProject.java
 * NetBeans JUnit based test
 *
 * Created on July 16, 2004, 2:56 PM
 */

package projects;

import junit.framework.*;

import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.JellyTestCase;
import org.netbeans.jellytools.NewProjectNameLocationStepOperator;
import org.netbeans.jellytools.NewProjectWizardOperator;
import org.netbeans.jellytools.WizardOperator;

import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;

import org.netbeans.junit.*;

/**
 *
 */
public class TestFreeformProject extends JellyTestCase {
    
    public TestFreeformProject(java.lang.String testName) {
        super(testName);
    }
    
    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
    public static Test suite() {
        TestSuite suite = new NbTestSuite(TestFreeformProject.class);
        return suite;
    }

    public void setUp() {
        System.out.println("########  " + getName() + "  #######"); // NOI18N
    }
    
    // -------------------------------------------------------------------------
    
    public void testCreateProject_1() throws Exception {
        
        String projName = "FreeForm_1"; // NOI18N
        
        createFreeformProject(projName, getWorkDir().getAbsolutePath() + java.io.File.separator + "freeform",
            getDataDir() + java.io.File.separator + "freeform1", 
            getDataDir() + java.io.File.separator + "freeform1" + java.io.File.separator + "build.xml");
        
        //NbDialogOperator scanningDialogOper = new NbDialogOperator("Scanning");
        //scanningDialogOper.waitClosed();
        //seems that scanning dialog is not poped for freeform projects
        
        // Verify that correct project has been created
        TestProjectUtils.verifyProjectExists(projName);
        
        // Verify that created project can be built
        TestProjectUtils.verifyProjectBuilds(projName);
        
    }
    
    // -------------------------------------------------------------------------
    
    private void createFreeformProject(String projName, String projFolder, 
            String projLocation, String buildScript) {
        
        // select the right template
        NewProjectWizardOperator npwo = NewProjectWizardOperator.invoke();
        String standardLabel = Bundle.getStringTrimmed("org.netbeans.modules.java.j2seproject.ui.wizards.Bundle", 
            "Templates/Project/Standard");
        npwo.selectCategory(standardLabel);
        String freeformLabel = Bundle.getStringTrimmed("org.netbeans.modules.java.freeform.resources.Bundle",
            "Templates/Project/Standard/j2sefreeform.xml");
        npwo.selectProject(freeformLabel);
        npwo.next();
        
        WizardOperator wo = new WizardOperator("New Java Project with Existing Ant Script");
        NewProjectNameLocationStepOperator npnlso = new NewProjectNameLocationStepOperator();
        
        // ERROR - returns null
        //npnlso.txtLocation().setText(projLocation);
        
        JTextFieldOperator locationOper = new JTextFieldOperator(wo, 3);
        locationOper.setText(projLocation);
        
        //npnlso.txtAntScript().setText(buildScript); // Wrong label: 'Ant Script:'
        JTextFieldOperator scriptOper = new JTextFieldOperator(wo, 0);
        scriptOper.setText(buildScript);
        
        // ERROR - returns null
        npnlso.txtProjectName().setText(projName);
        //JTextFieldOperator nameOper = new JTextFieldOperator(wo, 1);
        //nameOper.setText(projName);
        
        // ERROR - returns null
        npnlso.txtProjectFolder().setText(projFolder);
        //JTextFieldOperator folderOper = new JTextFieldOperator(wo, 2);
        //folderOper.setText(projFolder);
        
        wo.next();
        
        JComboBoxOperator buildTarget = new JComboBoxOperator(wo);
        buildTarget.enterText("jar"); // NOI18N
        
        wo.next();
        wo.finish();
                
    }
    
}
