/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.spi.editor.errorstripe.UpToDateStatus;
import org.netbeans.spi.editor.errorstripe.UpToDateStatusProvider;

/**
 *
 * @author Jan Lahoda
 */
final class JavaUpToDateStatusProvider extends UpToDateStatusProvider implements DocumentListener {
    
    private UpToDateStatus upToDate;
    
    public static JavaUpToDateStatusProvider get(Document doc) {
        JavaUpToDateStatusProvider provider = (JavaUpToDateStatusProvider) doc.getProperty(JavaUpToDateStatusProvider.class);
        
        if (provider == null) {
            doc.putProperty(JavaUpToDateStatusProvider.class, provider = new JavaUpToDateStatusProvider(doc));
        }
        
        return provider;
    }
    
    /** Creates a new instance of AnnotationMarkProvider */
    private JavaUpToDateStatusProvider(Document document) {
        upToDate = UpToDateStatus.UP_TO_DATE_OK;
        document.addDocumentListener(this);
    }
    
    public synchronized UpToDateStatus getUpToDate() {
        return upToDate;
    }
    
    private void setUpToDate(UpToDateStatus upToDate) {
        this.upToDate = upToDate;
        
        firePropertyChange(PROP_UP_TO_DATE, null, upToDate);
    }
    
    public synchronized void removeUpdate(DocumentEvent e) {
        setUpToDate(UpToDateStatus.UP_TO_DATE_DIRTY);
    }
    
    public synchronized void insertUpdate(DocumentEvent e) {
        setUpToDate(UpToDateStatus.UP_TO_DATE_DIRTY);
    }
    
    public void changedUpdate(DocumentEvent e) {
    }
    
    public synchronized void notifyParsingStarted() {
        setUpToDate(UpToDateStatus.UP_TO_DATE_PROCESSING);
    }
    
    public synchronized void notifyParsingFinished() {
        if (getUpToDate() == UpToDateStatus.UP_TO_DATE_PROCESSING)
            setUpToDate(UpToDateStatus.UP_TO_DATE_OK);
    }
    
}
